package org.codehaus.plexus.configuration.processor;

/*
 * Copyright 2001-2006 Codehaus Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.util.Map;

/**
 * @author <a href="mailto:jason@maven.org">Jason van Zyl</a>
 * @version $Id: AbstractConfigurationResourceHandler.java 4779 2006-11-23 04:09:31Z jvanzyl $
 */
public abstract class AbstractConfigurationResourceHandler
    implements ConfigurationResourceHandler
{
    protected String getSource( Map parameters )
        throws ConfigurationProcessingException
    {
        String source = (String) parameters.get( ConfigurationResourceHandler.SOURCE );

        if ( source == null )
        {
            throw new ConfigurationProcessingException(
                "The 'source' attribute for a configuration resource handler cannot be null." );
        }

        return source;
    }
}
