/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.cdc.gleaner;

import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaClassCache;
import com.thoughtworks.qdox.model.JavaField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.cdc.gleaner.ComponentGleanerException;
import org.codehaus.plexus.cdc.gleaner.ComponentGleanerSupport;
import org.codehaus.plexus.cdc.gleaner.SourceComponentGleaner;
import org.codehaus.plexus.component.repository.cdc.ComponentDescriptor;
import org.codehaus.plexus.component.repository.cdc.ComponentRequirement;
import org.codehaus.plexus.component.repository.cdc.ComponentRequirementList;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Configurable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Serviceable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Startable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Suspendable;
import org.codehaus.plexus.util.StringUtils;

public class QDoxComponentGleaner
extends ComponentGleanerSupport
implements SourceComponentGleaner {
    public static final String PLEXUS_COMPONENT_TAG = "plexus.component";
    public static final String PLEXUS_REQUIREMENT_TAG = "plexus.requirement";
    public static final String PLEXUS_CONFIGURATION_TAG = "plexus.configuration";
    public static final String PLEXUS_VERSION_PARAMETER = "version";
    public static final String PLEXUS_ROLE_PARAMETER = "role";
    public static final String PLEXUS_ROLE_HINT_PARAMETER = "role-hint";
    public static final String PLEXUS_ROLE_HINT_LIST_PARAMETER = "role-hints";
    public static final String PLEXUS_ALIAS_PARAMETER = "alias";
    public static final String PLEXUS_DEFAULT_VALUE_PARAMETER = "default-value";
    public static final String PLEXUS_LIFECYCLE_HANDLER_PARAMETER = "lifecycle-handler";
    public static final String PLEXUS_INSTANTIATION_STARTEGY_PARAMETER = "instantiation-strategy";
    public static final String PLEXUS_DEFAULT_HINT = "default";
    private static final List IGNORED_INTERFACES = Collections.unmodifiableList(Arrays.asList(LogEnabled.class.getName(), Initializable.class.getName(), Configurable.class.getName(), Contextualizable.class.getName(), Disposable.class.getName(), Startable.class.getName(), Suspendable.class.getName(), Serviceable.class.getName()));
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$List;

    public ComponentDescriptor glean(JavaClassCache classCache, JavaClass javaClass) throws ComponentGleanerException {
        int i;
        DocletTag tag = javaClass.getTagByName(PLEXUS_COMPONENT_TAG);
        if (tag == null) {
            return null;
        }
        Map parameters = tag.getNamedParameterMap();
        String fqn = javaClass.getFullyQualifiedName();
        this.log.debug("Creating descriptor for component: {}", (Object)fqn);
        ComponentDescriptor componentDescriptor = new ComponentDescriptor();
        componentDescriptor.setImplementation(fqn);
        String role = this.getParameter(parameters, PLEXUS_ROLE_PARAMETER);
        if (role == null && (role = this.findRole(javaClass)) == null) {
            this.log.warn("Could not figure out a role for the component '" + fqn + "'. " + "Please specify a role with a parameter '" + PLEXUS_ROLE_PARAMETER + "' " + "on the @" + PLEXUS_COMPONENT_TAG + " tag.");
            return null;
        }
        componentDescriptor.setRole(role);
        String roleHint = this.getParameter(parameters, PLEXUS_ROLE_HINT_PARAMETER);
        if (roleHint != null) {
            // empty if block
        }
        componentDescriptor.setRoleHint(roleHint);
        String version = this.getParameter(parameters, PLEXUS_VERSION_PARAMETER);
        componentDescriptor.setVersion(version);
        String lifecycleHandler = this.getParameter(parameters, PLEXUS_LIFECYCLE_HANDLER_PARAMETER);
        componentDescriptor.setLifecycleHandler(lifecycleHandler);
        String instatiationStrategy = this.getParameter(parameters, PLEXUS_INSTANTIATION_STARTEGY_PARAMETER);
        componentDescriptor.setInstantiationStrategy(instatiationStrategy);
        componentDescriptor.setAlias(this.getParameter(parameters, PLEXUS_ALIAS_PARAMETER));
        this.findExtraParameters(PLEXUS_COMPONENT_TAG, parameters);
        this.findRequirements(classCache, componentDescriptor, javaClass);
        String comment = javaClass.getComment();
        if (comment != null && (i = comment.indexOf(46)) > 0) {
            comment = comment.substring(0, i + 1);
        }
        componentDescriptor.setDescription(comment);
        XmlPlexusConfiguration configuration = new XmlPlexusConfiguration("configuration");
        this.findConfiguration(configuration, javaClass);
        componentDescriptor.setConfiguration((PlexusConfiguration)configuration);
        return componentDescriptor;
    }

    private String findRole(JavaClass javaClass) {
        JavaClass superClass;
        ArrayList<JavaClass> interfaces = new ArrayList<JavaClass>(Arrays.asList(javaClass.getImplementedInterfaces()));
        Iterator it = interfaces.iterator();
        while (it.hasNext()) {
            JavaClass ifc = (JavaClass)it.next();
            if (!IGNORED_INTERFACES.contains(ifc.getFullyQualifiedName())) continue;
            it.remove();
        }
        String role = null;
        String className = javaClass.getName();
        Iterator it2 = interfaces.iterator();
        while (it2.hasNext()) {
            String name;
            JavaClass ifc = (JavaClass)it2.next();
            String fqn = ifc.getFullyQualifiedName();
            String pkg = ifc.getPackage();
            if (pkg == null) {
                int index = fqn.lastIndexOf(46);
                if (index == -1) {
                    pkg = javaClass.getPackage();
                    fqn = pkg + "." + fqn;
                } else {
                    pkg = fqn.substring(0, index);
                }
            }
            if (fqn == null) {
                fqn = ifc.getName();
            }
            if (!className.endsWith(name = fqn.substring(pkg.length() + 1))) continue;
            if (role != null) {
                this.log.warn("Found several possible roles for component '" + javaClass.getFullyQualifiedName() + "', " + "will use '" + role + "', found: " + ifc.getName() + ".");
            }
            role = fqn;
        }
        if (role == null && (superClass = javaClass.getSuperJavaClass()) != null) {
            role = this.findRole(superClass);
        }
        return role;
    }

    private void findRequirements(JavaClassCache classCache, ComponentDescriptor componentDescriptor, JavaClass javaClass) {
        JavaField[] fields = javaClass.getFields();
        if (javaClass.getSuperJavaClass() != null) {
            this.findRequirements(classCache, componentDescriptor, javaClass.getSuperJavaClass());
        }
        for (int i = 0; i < fields.length; ++i) {
            ComponentRequirement cr;
            JavaField field = fields[i];
            DocletTag tag = field.getTagByName(PLEXUS_REQUIREMENT_TAG);
            if (tag == null) continue;
            HashMap parameters = new HashMap(tag.getNamedParameterMap());
            String requirementClass = field.getType().getJavaClass().getFullyQualifiedName();
            boolean isMap = requirementClass.equals((class$java$util$Map == null ? QDoxComponentGleaner.class$("java.util.Map") : class$java$util$Map).getName()) || requirementClass.equals((class$java$util$Collection == null ? QDoxComponentGleaner.class$("java.util.Collection") : class$java$util$Collection).getName());
            try {
                isMap = isMap || (class$java$util$Collection == null ? QDoxComponentGleaner.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom(Class.forName(requirementClass));
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            boolean isList = requirementClass.equals((class$java$util$List == null ? QDoxComponentGleaner.class$("java.util.List") : class$java$util$List).getName());
            String hint = this.getParameter(parameters, PLEXUS_ROLE_HINT_PARAMETER);
            if (isMap || isList) {
                cr = new ComponentRequirementList();
                String hintList = this.getParameter(parameters, PLEXUS_ROLE_HINT_LIST_PARAMETER);
                if (hintList != null) {
                    String[] hintArr = hintList.split(",");
                    ((ComponentRequirementList)cr).setRoleHints(Arrays.asList(hintArr));
                }
            } else {
                cr = new ComponentRequirement();
                cr.setRoleHint(hint);
            }
            String role = this.getParameter(parameters, PLEXUS_ROLE_PARAMETER);
            if (role == null) {
                cr.setRole(requirementClass);
            } else {
                cr.setRole(role);
            }
            cr.setFieldName(field.getName());
            if (isMap || isList) {
                if (hint != null) {
                    this.log.warn("Field: '" + field.getName() + "': A role hint cannot be specified if the " + "field is a java.util.Map or a java.util.List");
                    continue;
                }
                if (role == null) {
                    this.log.warn("Field: '" + field.getName() + "': A java.util.Map or java.util.List " + "requirement has to specify a '" + PLEXUS_ROLE_PARAMETER + "' parameter on " + "the @" + PLEXUS_REQUIREMENT_TAG + " tag so Plexus can know which components to " + "put in the map or list.");
                    continue;
                }
                JavaClass roleClass = classCache.getClassByName(role);
                if (role.indexOf(46) == -1 && StringUtils.isEmpty((String)roleClass.getPackage())) {
                    role = javaClass.getPackage() + "." + roleClass.getName();
                }
                cr.setRole(role);
                this.findExtraParameters(PLEXUS_REQUIREMENT_TAG, parameters);
            }
            componentDescriptor.addRequirement(cr);
        }
    }

    private void findConfiguration(XmlPlexusConfiguration configuration, JavaClass javaClass) throws ComponentGleanerException {
        JavaField[] fields = javaClass.getFields();
        if (javaClass.getSuperJavaClass() != null) {
            this.findConfiguration(configuration, javaClass.getSuperJavaClass());
        }
        for (int i = 0; i < fields.length; ++i) {
            JavaField field = fields[i];
            DocletTag tag = field.getTagByName(PLEXUS_CONFIGURATION_TAG);
            if (tag == null) continue;
            HashMap parameters = new HashMap(tag.getNamedParameterMap());
            String defaultValue = (String)parameters.remove(PLEXUS_DEFAULT_VALUE_PARAMETER);
            if (defaultValue == null) {
                this.log.warn("Component: " + javaClass.getName() + ", field name: '" + field.getName() + "': " + "Currently configurable fields will not be written to the descriptor " + "without a default value.");
                continue;
            }
            String name = this.deHump(field.getName());
            XmlPlexusConfiguration c = new XmlPlexusConfiguration(name);
            c.setValue(defaultValue);
            this.log.debug(" Configuration: {}={}", (Object)name, (Object)defaultValue);
            configuration.addChild((PlexusConfiguration)c);
            this.findExtraParameters(PLEXUS_CONFIGURATION_TAG, parameters);
        }
    }

    private void findExtraParameters(String tagName, Map parameters) {
        Iterator it = parameters.keySet().iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            this.log.warn("Extra parameter on the '" + tagName + "' tag: '" + s + "'.");
        }
    }

    private String getParameter(Map parameters, String parameter) {
        String value = (String)parameters.remove(parameter);
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        return value;
    }
}

