/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.tar;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.codehaus.plexus.archiver.AbstractUnArchiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.tar.TarFile;
import org.codehaus.plexus.archiver.tar.TarResource;
import org.codehaus.plexus.archiver.util.EnumeratedAttribute;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.util.IOUtil;

public class TarUnArchiver
extends AbstractUnArchiver {
    private UntarCompressionMethod compression = new UntarCompressionMethod();

    public TarUnArchiver() {
    }

    public TarUnArchiver(File sourceFile) {
        super(sourceFile);
    }

    public void setCompression(UntarCompressionMethod method) {
        this.compression = method;
    }

    public void setEncoding(String encoding) {
        this.getLogger().warn("The TarUnArchiver doesn't support the encoding attribute");
    }

    protected void execute() throws ArchiverException {
        this.execute(this.getSourceFile(), this.getDestDirectory());
    }

    protected void execute(String path, File outputDirectory) {
        this.execute(new File(path), this.getDestDirectory());
    }

    protected void execute(File sourceFile, File destDirectory) throws ArchiverException {
        TarArchiveInputStream tis = null;
        try {
            TarArchiveEntry te;
            this.getLogger().info("Expanding: " + sourceFile + " into " + destDirectory);
            TarFile tarFile = new TarFile(sourceFile);
            tis = new TarArchiveInputStream(this.compression.decompress(sourceFile, new BufferedInputStream(new FileInputStream(sourceFile))));
            while ((te = tis.getNextTarEntry()) != null) {
                TarResource fileInfo = new TarResource(tarFile, te);
                if (!this.isSelected(te.getName(), (PlexusIoResource)fileInfo)) continue;
                this.extractFile(sourceFile, destDirectory, (InputStream)tis, te.getName(), te.getModTime(), te.isDirectory(), te.getMode() != 0 ? Integer.valueOf(te.getMode()) : null);
            }
            this.getLogger().debug("expand complete");
        }
        catch (IOException ioe) {
            try {
                throw new ArchiverException("Error while expanding " + sourceFile.getAbsolutePath(), ioe);
            }
            catch (Throwable throwable) {
                IOUtil.close(tis);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)tis);
    }

    public static final class UntarCompressionMethod
    extends EnumeratedAttribute {
        public static final String NONE = "none";
        public static final String GZIP = "gzip";
        public static final String BZIP2 = "bzip2";

        public UntarCompressionMethod() {
            try {
                this.setValue(NONE);
            }
            catch (ArchiverException archiverException) {
                // empty catch block
            }
        }

        public UntarCompressionMethod(String method) {
            try {
                this.setValue(method);
            }
            catch (ArchiverException archiverException) {
                // empty catch block
            }
        }

        public String[] getValues() {
            return new String[]{NONE, GZIP, BZIP2};
        }

        private InputStream decompress(File file, InputStream istream) throws IOException, ArchiverException {
            String value = this.getValue();
            if (GZIP.equals(value)) {
                return new GZIPInputStream(istream);
            }
            if (BZIP2.equals(value)) {
                return new BZip2CompressorInputStream(istream);
            }
            return istream;
        }
    }
}

