/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.dependency.task;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.webstart.dependency.JnlpDependencyConfig;
import org.codehaus.mojo.webstart.dependency.task.AbstractJnlpTask;
import org.codehaus.mojo.webstart.dependency.task.JnlpDependencyTask;
import org.codehaus.mojo.webstart.dependency.task.JnlpDependencyTaskException;
import org.codehaus.mojo.webstart.sign.SignConfig;
import org.codehaus.mojo.webstart.sign.SignTool;
import org.codehaus.mojo.webstart.util.IOUtil;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=JnlpDependencyTask.class, hint="SignTask", instantiationStrategy="per-lookup")
public class SignTask
extends AbstractJnlpTask {
    public static final String ROLE_HINT = "SignTask";
    @Requirement
    private SignTool signTool;
    @Requirement
    private IOUtil ioUtil;

    public void check(JnlpDependencyConfig config) {
        boolean jarSigned;
        if (config == null) {
            throw new NullPointerException("config can't be null");
        }
        if (config.getArtifact() == null) {
            throw new NullPointerException("config.artifact can't be null");
        }
        if (config.getArtifact().getFile() == null) {
            throw new NullPointerException("config.artifact.file can't be null");
        }
        if (!config.isSign()) {
            throw new IllegalStateException("Can't sign if config.isSign is false");
        }
        File file = config.getArtifact().getFile();
        try {
            jarSigned = this.signTool.isJarSigned(file);
        }
        catch (MojoExecutionException e) {
            throw new RuntimeException(e.getMessage(), e.getCause());
        }
        if (jarSigned && !config.isCanUnsign()) {
            throw new IllegalStateException("Can't unsign the config.artifact.file if config.isCanUsign is false");
        }
    }

    public File execute(JnlpDependencyConfig config, File file) throws JnlpDependencyTaskException {
        SignConfig sign = config.getSign();
        boolean signVerify = sign.isVerify();
        File signedJar = new File(file.getParentFile(), file.getName() + ".sign");
        try {
            this.ioUtil.deleteFile(signedJar);
        }
        catch (MojoExecutionException e) {
            throw new JnlpDependencyTaskException(e.getMessage(), e.getCause());
        }
        this.verboseLog(config, "Sign " + signedJar.getName());
        try {
            this.signTool.sign(sign, file, signedJar);
        }
        catch (MojoExecutionException e) {
            throw new JnlpDependencyTaskException(e.getMessage(), e.getCause());
        }
        this.getLogger().debug("lastModified signedJar:" + signedJar.lastModified() + " not signed Jar:" + file.lastModified());
        if (signVerify) {
            this.verboseLog(config, "Verify signature of " + signedJar.getName());
            try {
                this.signTool.verify(sign, signedJar, config.isVerbose());
            }
            catch (MojoExecutionException e) {
                throw new JnlpDependencyTaskException(e.getMessage(), e.getCause());
            }
        }
        return signedJar;
    }
}

