/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.generator;

import java.io.File;
import java.util.Collection;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.webstart.ResolvedJarResource;
import org.codehaus.mojo.webstart.generator.AbstractGenerator;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarResourcesGenerator
extends AbstractGenerator {
    private final Collection<ResolvedJarResource> jarResources;
    private String libPath;

    public JarResourcesGenerator(Log log, MavenProject mavenProject, File resourceLoaderPath, String defaultTemplateResourceName, File outputFile, String templateFile, Collection<ResolvedJarResource> jarResources, String mainClass, String webstartJarURL, String libPath, String encoding) {
        super(log, mavenProject, resourceLoaderPath, defaultTemplateResourceName, outputFile, templateFile, mainClass, webstartJarURL, encoding);
        this.jarResources = jarResources;
        this.libPath = libPath;
    }

    @Override
    protected String getDependenciesText() {
        String jarResourcesText = "";
        if (this.jarResources.size() != 0) {
            int multiplier = 100;
            StringBuilder buffer = new StringBuilder(100 * this.jarResources.size());
            buffer.append("\n");
            for (ResolvedJarResource jarResource : this.jarResources) {
                if (!jarResource.isIncludeInJnlp()) continue;
                buffer.append("<jar href=\"");
                if (StringUtils.isNotEmpty((String)this.libPath)) {
                    buffer.append(this.libPath);
                    buffer.append('/');
                }
                buffer.append(jarResource.getHrefValue());
                buffer.append("\"");
                if (jarResource.isOutputJarVersion()) {
                    buffer.append(" version=\"").append(jarResource.getVersion()).append("\"");
                }
                if (jarResource.getMainClass() != null) {
                    buffer.append(" main=\"true\"");
                }
                buffer.append("/>\n");
            }
            jarResourcesText = buffer.toString();
        }
        return jarResourcesText;
    }
}

