/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.resolver.filter.IncludesArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.jar.JarSignMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.settings.Settings;
import org.codehaus.mojo.keytool.GenkeyMojo;
import org.codehaus.mojo.webstart.JnlpConfig;
import org.codehaus.mojo.webstart.Pack200;
import org.codehaus.mojo.webstart.SignConfig;
import org.codehaus.mojo.webstart.generator.Generator;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public class JnlpMojo
extends AbstractMojo {
    protected File workDirectory;
    private ZipArchiver zipArchiver;
    private MavenProject project;
    private JnlpConfig jnlp;
    private Dependencies dependencies;
    private SignConfig sign;
    private KeystoreConfig keystore;
    private boolean verifyjar;
    private boolean pack200;
    private boolean gzip;
    private boolean verbose;
    private File basedir;
    private ArtifactResolver artifactResolver;
    private ArtifactFactory artifactFactory;
    protected ArtifactRepository localRepository;
    private MavenProjectHelper projectHelper;
    private Settings settings;
    private PluginManager pluginManager;
    private FileFilter modifiedFileFilter = new FileFilter(){

        public boolean accept(File pathname) {
            boolean modified = pathname.lastModified() > JnlpMojo.this.getStartTime();
            JnlpMojo.this.getLog().debug((CharSequence)("File: " + pathname.getName() + " modified: " + modified));
            JnlpMojo.this.getLog().debug((CharSequence)("lastModified: " + pathname.lastModified() + " plugin start time " + JnlpMojo.this.getStartTime()));
            return modified;
        }
    };
    private FileFilter jarFileFilter = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.getName().endsWith(".jar");
        }
    };
    private FileFilter pack200FileFilter = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.isFile() && (pathname.getName().endsWith(".jar.pack.gz") || pathname.getName().endsWith(".jar.pack"));
        }
    };
    private FileFilter updatedJarFileFilter = new CompositeFileFilter(this.jarFileFilter, this.modifiedFileFilter);
    private FileFilter updatedPack200FileFilter = new CompositeFileFilter(this.pack200FileFilter, this.modifiedFileFilter);
    private List packagedJnlpArtifacts = new ArrayList();
    private List modifiedJnlpArtifacts = new ArrayList();
    private Artifact artifactWithMainClass;
    private long startTime;
    static /* synthetic */ Class array$Ljava$lang$String;

    private long getStartTime() {
        if (this.startTime == 0L) {
            throw new IllegalStateException("startTime not initialized");
        }
        return this.startTime;
    }

    public void execute() throws MojoExecutionException {
        this.checkInput();
        this.startTime = System.currentTimeMillis() - 1000L;
        File workDirectory = this.getWorkDirectory();
        this.getLog().debug((CharSequence)("using work directory " + workDirectory));
        if (!workDirectory.exists() && !workDirectory.mkdirs()) {
            throw new MojoExecutionException("Failed to create: " + workDirectory.getAbsolutePath());
        }
        try {
            File resourcesDir = this.getJnlp().getResources();
            if (resourcesDir == null) {
                resourcesDir = new File(this.project.getBasedir(), "src/main/jnlp");
            }
            this.copyResources(resourcesDir, workDirectory);
            this.artifactWithMainClass = null;
            this.processDependencies();
            if (this.artifactWithMainClass == null) {
                throw new MojoExecutionException("didn't find artifact with main class: " + this.jnlp.getMainClass() + ". Did you specify it? ");
            }
            if ((this.pack200 || this.sign != null) && this.getLog().isDebugEnabled()) {
                this.logCollection("Some dependencies may be skipped. Here's the list of the artifacts that should be signed/packed: ", this.modifiedJnlpArtifacts);
            }
            if (this.sign != null) {
                int signedJars;
                if (this.keystore != null && this.keystore.isGen()) {
                    if (this.keystore.isDelete()) {
                        this.deleteKeyStore();
                    }
                    this.genKeyStore();
                }
                if (this.pack200) {
                    Pack200.packJars((File)workDirectory, (FileFilter)this.updatedJarFileFilter, (boolean)this.gzip);
                    Pack200.unpackJars((File)workDirectory, (FileFilter)this.updatedPack200FileFilter);
                }
                if ((signedJars = this.signJars(workDirectory, this.updatedJarFileFilter)) != this.modifiedJnlpArtifacts.size()) {
                    throw new IllegalStateException("the number of signed artifacts differ from the number of modified artifacts. Implementation error");
                }
            }
            if (this.pack200) {
                this.getLog().debug((CharSequence)"packing jars");
                Pack200.packJars((File)workDirectory, (FileFilter)this.updatedJarFileFilter, (boolean)this.gzip);
            }
            this.generateJnlpFile(workDirectory);
            File toFile = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".zip");
            if (toFile.exists()) {
                this.getLog().debug((CharSequence)("deleting file " + toFile));
                toFile.delete();
            }
            this.zipArchiver.addDirectory(workDirectory);
            this.zipArchiver.setDestFile(toFile);
            this.getLog().debug((CharSequence)"about to call createArchive");
            this.zipArchiver.createArchive();
            this.projectHelper.attachArtifact(this.project, "zip", toFile);
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failure to run the plugin: ", e);
        }
    }

    private void copyResources(File resourcesDir, File workDirectory) throws IOException {
        if (!resourcesDir.exists()) {
            this.getLog().info((CharSequence)("No resources found in " + resourcesDir.getAbsolutePath()));
        } else if (!resourcesDir.isDirectory()) {
            this.getLog().debug((CharSequence)("Not a directory: " + resourcesDir.getAbsolutePath()));
        } else {
            this.getLog().debug((CharSequence)("Copying resources from " + resourcesDir.getAbsolutePath()));
            String excludes = JnlpMojo.concat(DirectoryScanner.DEFAULTEXCLUDES, ", ");
            this.copyDirectoryStructure(resourcesDir, workDirectory, "**", excludes);
        }
    }

    private static String concat(String[] array, String delim) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(delim);
            }
            String s = array[i];
            buffer.append(s).append(delim);
        }
        return buffer.toString();
    }

    private void copyDirectoryStructure(File sourceDirectory, File destinationDirectory, String includes, String excludes) throws IOException {
        if (!sourceDirectory.exists()) {
            return;
        }
        List files = FileUtils.getFiles((File)sourceDirectory, (String)includes, (String)excludes);
        Iterator i = files.iterator();
        while (i.hasNext()) {
            File file = (File)i.next();
            this.getLog().debug((CharSequence)("Copying " + file + " to " + destinationDirectory));
            String path = file.getAbsolutePath().substring(sourceDirectory.getAbsolutePath().length() + 1);
            File destDir = new File(destinationDirectory, path);
            this.getLog().debug((CharSequence)("Copying " + file + " to " + destDir));
            if (file.isDirectory()) {
                destDir.mkdirs();
                continue;
            }
            FileUtils.copyFileToDirectory((File)file, (File)destDir.getParentFile());
        }
    }

    private void processDependencies() throws IOException {
        this.processDependency(this.getProject().getArtifact());
        AndArtifactFilter filter = new AndArtifactFilter();
        if (this.dependencies != null && this.dependencies.getIncludes() != null && !this.dependencies.getIncludes().isEmpty()) {
            filter.add((ArtifactFilter)new IncludesArtifactFilter(this.dependencies.getIncludes()));
        }
        if (this.dependencies != null && this.dependencies.getExcludes() != null && !this.dependencies.getExcludes().isEmpty()) {
            filter.add((ArtifactFilter)new ExcludesArtifactFilter(this.dependencies.getExcludes()));
        }
        Set artifacts = this.getProject().getArtifacts();
        Iterator it = artifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            if (!filter.include(artifact)) continue;
            this.processDependency(artifact);
        }
    }

    private void processDependency(Artifact artifact) throws IOException {
        if (!"provided".equals(artifact.getScope()) && !"test".equals(artifact.getScope())) {
            String type = artifact.getType();
            if ("jar".equals(type)) {
                File toCopy = artifact.getFile();
                if (toCopy == null) {
                    this.getLog().error((CharSequence)("artifact with no file: " + artifact));
                    this.getLog().error((CharSequence)("artifact download url: " + artifact.getDownloadUrl()));
                    this.getLog().error((CharSequence)("artifact repository: " + artifact.getRepository()));
                    this.getLog().error((CharSequence)("artifact repository: " + artifact.getVersion()));
                    throw new IllegalStateException("artifact " + artifact + " has no matching file, why? Check the logs...");
                }
                boolean copied = this.copyFileToDirectoryIfNecessary(toCopy, this.getWorkDirectory());
                if (copied) {
                    String name = toCopy.getName();
                    this.modifiedJnlpArtifacts.add(name.substring(0, name.lastIndexOf(46)));
                }
                this.packagedJnlpArtifacts.add(artifact);
                if (this.artifactContainsClass(artifact, this.jnlp.getMainClass())) {
                    if (this.artifactWithMainClass == null) {
                        this.artifactWithMainClass = artifact;
                        this.getLog().debug((CharSequence)("Found main jar. Artifact " + this.artifactWithMainClass + " contains the main class: " + this.jnlp.getMainClass()));
                    } else {
                        this.getLog().warn((CharSequence)("artifact " + artifact + " also contains the main class: " + this.jnlp.getMainClass() + ". IGNORED."));
                    }
                }
            } else {
                this.getLog().debug((CharSequence)("Skipping artifact of type " + type + " for " + this.getWorkDirectory().getName()));
            }
        }
    }

    private boolean artifactContainsClass(Artifact artifact, String mainClass) throws MalformedURLException {
        boolean containsClass = true;
        URLClassLoader cl = new URLClassLoader(new URL[]{artifact.getFile().toURL()});
        Class<?> c = null;
        try {
            c = Class.forName(mainClass, false, cl);
        }
        catch (ClassNotFoundException e) {
            this.getLog().debug((CharSequence)("artifact " + artifact + " doesn't contain the main class: " + mainClass));
            containsClass = false;
        }
        catch (Throwable t) {
            this.getLog().info((CharSequence)("artifact " + artifact + " seems to contain the main class: " + mainClass + " but the jar doesn't seem to contain all dependencies " + t.getMessage()));
        }
        if (c != null) {
            this.getLog().debug((CharSequence)"Checking if the loaded class contains a main method.");
            try {
                c.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = JnlpMojo.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            }
            catch (NoSuchMethodException e) {
                this.getLog().warn((CharSequence)("The specified main class (" + mainClass + ") doesn't seem to contain a main method... Please check your configuration." + e.getMessage()));
            }
            catch (NoClassDefFoundError e) {
                this.getLog().warn((CharSequence)("Something failed while checking if the main class contains the main() method. This is probably due to the limited classpath we have provided to the class loader. The specified main class (" + mainClass + ") found in the jar is *assumed* to contain a main method... " + e.getMessage()));
            }
            catch (Throwable t) {
                this.getLog().error((CharSequence)("Unknown error: Couldn't check if the main class has a main method. The specified main class (" + mainClass + ") found in the jar is *assumed* to contain a main method..."), t);
            }
        }
        return containsClass;
    }

    void generateJnlpFile(File outputDirectory) throws MojoExecutionException {
        if (this.jnlp.getOutputFile() == null || this.jnlp.getOutputFile().length() == 0) {
            this.getLog().debug((CharSequence)"Jnlp output file name not specified. Using default output file name: launch.jnlp.");
            this.jnlp.setOutputFile("launch.jnlp");
        }
        File jnlpOutputFile = new File(outputDirectory, this.jnlp.getOutputFile());
        if (this.jnlp.getInputTemplate() == null || this.jnlp.getInputTemplate().length() == 0) {
            this.getLog().debug((CharSequence)"Jnlp template file name not specified. Using default output file name: src/jnlp/template.vm.");
            this.jnlp.setInputTemplate("src/jnlp/template.vm");
        }
        String templateFileName = this.jnlp.getInputTemplate();
        File resourceLoaderPath = this.getProject().getBasedir();
        if (this.jnlp.getInputTemplateResourcePath() != null && this.jnlp.getInputTemplateResourcePath().length() > 0) {
            resourceLoaderPath = new File(this.jnlp.getInputTemplateResourcePath());
        }
        Generator jnlpGenerator = new Generator(this, resourceLoaderPath, jnlpOutputFile, templateFileName);
        try {
            jnlpGenerator.generate();
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)e.toString());
            throw new MojoExecutionException("Could not generate the JNLP deployment descriptor", e);
        }
    }

    private void logCollection(String prefix, Collection collection) {
        this.getLog().debug((CharSequence)(prefix + " " + collection));
        if (collection == null) {
            return;
        }
        Iterator it3 = collection.iterator();
        while (it3.hasNext()) {
            this.getLog().debug((CharSequence)(prefix + it3.next()));
        }
    }

    private void deleteKeyStore() {
        File keyStore = null;
        if (this.sign.getKeystore() != null) {
            keyStore = new File(this.sign.getKeystore());
        }
        if (keyStore == null) {
            return;
        }
        if (keyStore.exists()) {
            if (keyStore.delete()) {
                this.getLog().debug((CharSequence)("deleted keystore from: " + keyStore.getAbsolutePath()));
            } else {
                this.getLog().warn((CharSequence)("Couldn't delete keystore from: " + keyStore.getAbsolutePath()));
            }
        } else {
            this.getLog().debug((CharSequence)("Skipping deletion of non existing keystore: " + keyStore.getAbsolutePath()));
        }
    }

    private void genKeyStore() throws MojoExecutionException {
        GenkeyMojo genKeystore = new GenkeyMojo();
        genKeystore.setAlias(this.sign.getAlias());
        genKeystore.setDname(this.sign.getDname());
        genKeystore.setKeyalg(this.sign.getKeyalg());
        genKeystore.setKeypass(this.sign.getKeypass());
        genKeystore.setKeysize(this.sign.getKeysize());
        genKeystore.setKeystore(this.sign.getKeystore());
        genKeystore.setSigalg(this.sign.getSigalg());
        genKeystore.setStorepass(this.sign.getStorepass());
        genKeystore.setStoretype(this.sign.getStoretype());
        genKeystore.setValidity(this.sign.getValidity());
        genKeystore.setVerbose(this.verbose);
        genKeystore.setWorkingDir(this.getWorkDirectory());
        genKeystore.execute();
    }

    private File getWorkDirectory() {
        return this.workDirectory;
    }

    private boolean copyFileToDirectoryIfNecessary(File sourceFile, File targetDirectory) throws IOException {
        boolean shouldCopy;
        if (sourceFile == null) {
            throw new NullPointerException("sourceFile is null");
        }
        File targetFile = new File(targetDirectory, sourceFile.getName());
        boolean bl = shouldCopy = !targetFile.exists() || targetFile.lastModified() < sourceFile.lastModified();
        if (shouldCopy) {
            FileUtils.copyFileToDirectory((File)sourceFile, (File)targetDirectory);
        } else {
            this.getLog().debug((CharSequence)("Source file hasn't changed. Do not overwrite " + targetFile + " with " + sourceFile + "."));
        }
        return shouldCopy;
    }

    private int signJars(File directory, FileFilter fileFilter) throws MojoExecutionException {
        File[] jarFiles = directory.listFiles(fileFilter);
        this.getLog().debug((CharSequence)("signJars in " + directory + " found " + jarFiles.length + " jar(s) to sign"));
        if (jarFiles.length == 0) {
            return 0;
        }
        JarSignMojo signJar = new JarSignMojo();
        signJar.setAlias(this.sign.getAlias());
        signJar.setBasedir(this.basedir);
        signJar.setKeypass(this.sign.getKeypass());
        signJar.setKeystore(this.sign.getKeystore());
        signJar.setSigFile(this.sign.getSigfile());
        signJar.setStorepass(this.sign.getStorepass());
        signJar.setType(this.sign.getStoretype());
        signJar.setVerbose(this.verbose);
        signJar.setWorkingDir(this.getWorkDirectory());
        signJar.setVerify(this.sign.getVerify());
        for (int i = 0; i < jarFiles.length; ++i) {
            signJar.setJarPath(jarFiles[i]);
            signJar.setSignedJar(null);
            long lastModified = jarFiles[i].lastModified();
            signJar.execute();
            jarFiles[i].setLastModified(lastModified);
        }
        return jarFiles.length;
    }

    private void checkInput() throws MojoExecutionException {
        this.getLog().debug((CharSequence)("a fact " + this.artifactFactory));
        this.getLog().debug((CharSequence)("a resol " + this.artifactResolver));
        this.getLog().debug((CharSequence)("basedir " + this.basedir));
        this.getLog().debug((CharSequence)("gzip " + this.gzip));
        this.getLog().debug((CharSequence)("pack200 " + this.pack200));
        this.getLog().debug((CharSequence)("project " + this.getProject()));
        this.getLog().debug((CharSequence)("zipArchiver " + this.zipArchiver));
        this.getLog().debug((CharSequence)("verifyjar " + this.verifyjar));
        this.getLog().debug((CharSequence)("verbose " + this.verbose));
        if (this.jnlp == null) {
            throw new MojoExecutionException("<jnlp> configuration element missing.");
        }
        if (SystemUtils.JAVA_VERSION_FLOAT < 1.5f && this.pack200) {
            throw new MojoExecutionException("SDK 5.0 minimum when using pack200.");
        }
    }

    public MavenProject getProject() {
        return this.project;
    }

    void setWorkDirectory(File workDirectory) {
        this.workDirectory = workDirectory;
    }

    void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public JnlpConfig getJnlp() {
        return this.jnlp;
    }

    public List getPackagedJnlpArtifacts() {
        return this.packagedJnlpArtifacts;
    }

    public boolean isArtifactWithMainClass(Artifact artifact) {
        boolean b = this.artifactWithMainClass.equals(artifact);
        this.getLog().debug((CharSequence)("compare " + this.artifactWithMainClass + " with " + artifact + ": " + b));
        return b;
    }

    public String getSpec() {
        if (this.jnlp.getSpec() != null) {
            return this.jnlp.getSpec();
        }
        return "1.0+";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CompositeFileFilter
    implements FileFilter {
        private List fileFilters = new ArrayList();

        CompositeFileFilter(FileFilter filter1, FileFilter filter2) {
            this.fileFilters.add(filter1);
            this.fileFilters.add(filter2);
        }

        public boolean accept(File pathname) {
            for (int i = 0; i < this.fileFilters.size(); ++i) {
                if (((FileFilter)this.fileFilters.get(i)).accept(pathname)) continue;
                return false;
            }
            return true;
        }
    }

    public static class KeystoreConfig {
        private boolean delete;
        private boolean gen;

        public boolean isDelete() {
            return this.delete;
        }

        public void setDelete(boolean delete) {
            this.delete = delete;
        }

        public boolean isGen() {
            return this.gen;
        }

        public void setGen(boolean gen) {
            this.gen = gen;
        }
    }

    public static class Dependencies {
        private List includes;
        private List excludes;

        public List getIncludes() {
            return this.includes;
        }

        public void setIncludes(List includes) {
            this.includes = includes;
        }

        public List getExcludes() {
            return this.excludes;
        }

        public void setExcludes(List excludes) {
            this.excludes = excludes;
        }
    }
}

