/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.filtering;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.versions.filtering.TokenizedMatcher;
import org.codehaus.mojo.versions.utils.DependencyComparator;

public class DependencyFilter {
    private final String pattern;
    private final List<TokenizedMatcher> matchers;

    DependencyFilter(String pattern, List<TokenizedMatcher> matchers) {
        this.pattern = pattern;
        this.matchers = matchers;
    }

    public static DependencyFilter parseFrom(List<String> dependencies) {
        List<TokenizedMatcher> matchers = dependencies.stream().map(TokenizedMatcher::parse).collect(Collectors.toList());
        String debugPattern = String.join((CharSequence)",", dependencies);
        return new DependencyFilter(debugPattern, matchers);
    }

    private static <T> Predicate<T> not(Predicate<T> predicate) {
        return x -> !predicate.test(x);
    }

    public String toString() {
        return String.format("%s{%s}", this.getClass().getSimpleName(), this.pattern);
    }

    public Set<Dependency> retainingIn(Collection<Dependency> dependencies) {
        return this.filterBy(dependencies, this::matchersMatch);
    }

    public Set<Dependency> removingFrom(Collection<Dependency> dependencies) {
        return this.filterBy(dependencies, DependencyFilter.not(this::matchersMatch));
    }

    private boolean matchersMatch(Dependency dependency) {
        return this.matchers.stream().anyMatch(m -> m.test(dependency));
    }

    private TreeSet<Dependency> filterBy(Collection<Dependency> dependencies, Predicate<Dependency> predicate) {
        return dependencies.stream().filter(predicate).collect(Collectors.toCollection(() -> new TreeSet<Dependency>(DependencyComparator.INSTANCE)));
    }

    public static Set<Dependency> filterDependencies(Collection<Dependency> dependencies, List<String> includes, List<String> excludes, String section, Log log) {
        DependencyFilter includeDeps = DependencyFilter.parseFrom(includes);
        DependencyFilter excludeDeps = DependencyFilter.parseFrom(excludes);
        Set<Dependency> filtered = includeDeps.retainingIn(dependencies);
        filtered = excludeDeps.removingFrom(filtered);
        if (log != null && log.isDebugEnabled()) {
            log.debug((CharSequence)String.format("parsed includes in %s: %s -> %s", section, includes, includeDeps));
            log.debug((CharSequence)String.format("parsed excludes in %s: %s -> %s", section, excludes, excludeDeps));
            log.debug((CharSequence)(String.format("Unfiltered %s: ", section) + DependencyFilter.output(dependencies)));
            log.debug((CharSequence)(String.format("Filtered %s: ", section) + DependencyFilter.output(filtered)));
        }
        return filtered;
    }

    private static String output(Collection<Dependency> dependencies) {
        return dependencies.stream().map(d -> String.format("%s:%s:%s", d.getGroupId(), d.getArtifactId(), d.getVersion())).collect(Collectors.joining(", "));
    }
}

