/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.change.VersionChange;
import org.codehaus.mojo.versions.change.VersionChanger;
import org.codehaus.mojo.versions.change.VersionChangerFactory;
import org.codehaus.mojo.versions.ordering.ReactorDepthComparator;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.mojo.versions.utils.DelegatingContextualLog;
import org.codehaus.mojo.versions.utils.RegexUtils;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="set", requiresProject=true, requiresDirectInvocation=true, aggregator=true)
public class SetMojo
extends AbstractVersionsUpdaterMojo {
    private static final String SNAPSHOT = "-SNAPSHOT";
    @Parameter(property="newVersion")
    private String newVersion;
    @Parameter(property="groupId", defaultValue="${project.groupId}")
    private String groupId;
    @Parameter(property="artifactId", defaultValue="${project.artifactId}")
    private String artifactId;
    @Parameter(property="oldVersion", defaultValue="${project.version}")
    private String oldVersion;
    @Parameter(property="updateMatchingVersions", defaultValue="true")
    private boolean updateMatchingVersions;
    @Parameter(property="processParent", defaultValue="true")
    private boolean processParent;
    @Parameter(property="processProject", defaultValue="true")
    private boolean processProject;
    @Parameter(property="processDependencies", defaultValue="true")
    private boolean processDependencies;
    @Parameter(property="processPlugins", defaultValue="true")
    private boolean processPlugins;
    @Component
    private Prompter prompter;
    @Parameter(property="removeSnapshot", defaultValue="false")
    private boolean removeSnapshot;
    @Parameter(property="nextSnapshot", defaultValue="false")
    private boolean nextSnapshot;
    @Parameter(property="processAllModules", defaultValue="false")
    private boolean processAllModules;
    private final transient List<VersionChange> sourceChanges = new ArrayList<VersionChange>();

    private synchronized void addChange(String groupId, String artifactId, String oldVersion, String newVersion) {
        if (!newVersion.equals(oldVersion)) {
            this.sourceChanges.add(new VersionChange(groupId, artifactId, oldVersion, newVersion));
        }
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        String version;
        if (this.getProject().getOriginalModel().getVersion() == null) {
            throw new MojoExecutionException("Project version is inherited from parent.");
        }
        if (this.removeSnapshot && !this.nextSnapshot && (version = this.getVersion()).endsWith(SNAPSHOT)) {
            String release;
            this.newVersion = release = version.substring(0, version.indexOf(SNAPSHOT));
            this.getLog().info((CharSequence)("SNAPSHOT found.  BEFORE " + version + "  --> AFTER: " + this.newVersion));
        }
        if (!this.removeSnapshot && this.nextSnapshot) {
            String version2;
            boolean havingSnapshot = false;
            String versionWithoutSnapshot = version2 = this.getVersion();
            if (version2.endsWith(SNAPSHOT)) {
                havingSnapshot = true;
                versionWithoutSnapshot = version2.substring(0, version2.indexOf(SNAPSHOT));
            }
            LinkedList<String> numbers = new LinkedList<String>();
            if (versionWithoutSnapshot.contains(".")) {
                Collections.addAll(numbers, versionWithoutSnapshot.split("\\."));
            } else {
                numbers.add(versionWithoutSnapshot);
            }
            int lastNumber = Integer.parseInt((String)numbers.removeLast());
            numbers.addLast(String.valueOf(lastNumber + 1));
            String nextVersion = StringUtils.join((Object[])numbers.toArray(new String[0]), (String)".");
            if (havingSnapshot) {
                this.newVersion = nextVersion + SNAPSHOT;
            }
            this.getLog().info((CharSequence)("SNAPSHOT found.  BEFORE " + version2 + "  --> AFTER: " + this.newVersion));
        }
        if (StringUtils.isEmpty((String)this.newVersion)) {
            if (this.settings.isInteractiveMode()) {
                try {
                    this.newVersion = this.prompter.prompt("Enter the new version to set", this.getProject().getOriginalModel().getVersion());
                }
                catch (PrompterException e) {
                    throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
                }
            } else {
                throw new MojoExecutionException("You must specify the new version, either by using the newVersion property (that is -DnewVersion=... on the command line) or run in interactive mode");
            }
        }
        if (StringUtils.isEmpty((String)this.newVersion)) {
            throw new MojoExecutionException("You must specify the new version, either by using the newVersion property (that is -DnewVersion=... on the command line) or run in interactive mode");
        }
        try {
            MavenProject project = PomHelper.getLocalRoot(this.projectBuilder, this.getProject(), this.localRepository, null, this.getLog());
            this.getLog().info((CharSequence)("Local aggregation root: " + project.getBasedir()));
            Map<String, Model> reactorModels = PomHelper.getReactorModels(project, this.getLog());
            TreeMap<String, Model> reactor = new TreeMap<String, Model>(new ReactorDepthComparator(reactorModels));
            reactor.putAll(reactorModels);
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            this.getLog().info((CharSequence)("Processing change of " + this.groupId + ":" + this.artifactId + ":" + this.oldVersion + " -> " + this.newVersion));
            Pattern groupIdRegex = Pattern.compile(RegexUtils.convertWildcardsToRegex(SetMojo.fixNullOrEmpty(this.groupId, "*"), true));
            Pattern artifactIdRegex = Pattern.compile(RegexUtils.convertWildcardsToRegex(SetMojo.fixNullOrEmpty(this.artifactId, "*"), true));
            Pattern oldVersionIdRegex = Pattern.compile(RegexUtils.convertWildcardsToRegex(SetMojo.fixNullOrEmpty(this.oldVersion, "*"), true));
            boolean found = false;
            for (Model m : reactor.values()) {
                String mGroupId = PomHelper.getGroupId(m);
                String mArtifactId = PomHelper.getArtifactId(m);
                String mVersion = PomHelper.getVersion(m);
                if ((!groupIdRegex.matcher(mGroupId).matches() || !artifactIdRegex.matcher(mArtifactId).matches()) && !this.processAllModules || !oldVersionIdRegex.matcher(mVersion).matches() || this.newVersion.equals(mVersion)) continue;
                found = true;
                this.applyChange(project, reactor, files, mGroupId, m.getArtifactId(), StringUtils.isBlank((String)this.oldVersion) || "*".equals(this.oldVersion) ? "" : m.getVersion());
            }
            if (!found && RegexUtils.getWildcardScore(this.groupId) == 0 && RegexUtils.getWildcardScore(this.artifactId) == 0 && RegexUtils.getWildcardScore(this.oldVersion) == 0) {
                this.applyChange(project, reactor, files, this.groupId, this.artifactId, this.oldVersion);
            }
            for (File file : files) {
                this.process(file);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private static String fixNullOrEmpty(String value, String defaultValue) {
        return StringUtils.isBlank((String)value) ? defaultValue : value;
    }

    private void applyChange(MavenProject project, SortedMap<String, Model> reactor, Set<File> files, String groupId, String artifactId, String oldVersion) {
        this.getLog().debug((CharSequence)("Applying change " + groupId + ":" + artifactId + ":" + oldVersion + " -> " + this.newVersion));
        this.addChange(groupId, artifactId, oldVersion, this.newVersion);
        Map.Entry<String, Model> current = PomHelper.getModelEntry(reactor, groupId, artifactId);
        current.getValue().setVersion(this.newVersion);
        this.addFile(files, project, current.getKey());
        for (Map.Entry<String, Model> sourceEntry : reactor.entrySet()) {
            String sourcePath = sourceEntry.getKey();
            Model sourceModel = sourceEntry.getValue();
            this.getLog().debug((CharSequence)(sourcePath.length() == 0 ? "Processing root module as parent" : "Processing " + sourcePath + " as a parent."));
            String sourceGroupId = PomHelper.getGroupId(sourceModel);
            if (sourceGroupId == null) {
                this.getLog().warn((CharSequence)("Module " + sourcePath + " is missing a groupId."));
                continue;
            }
            String sourceArtifactId = PomHelper.getArtifactId(sourceModel);
            if (sourceArtifactId == null) {
                this.getLog().warn((CharSequence)("Module " + sourcePath + " is missing an artifactId."));
                continue;
            }
            String sourceVersion = PomHelper.getVersion(sourceModel);
            if (sourceVersion == null) {
                this.getLog().warn((CharSequence)("Module " + sourcePath + " is missing a version."));
                continue;
            }
            this.addFile(files, project, sourcePath);
            this.getLog().debug((CharSequence)("Looking for modules which use " + ArtifactUtils.versionlessKey((String)sourceGroupId, (String)sourceArtifactId) + " as their parent"));
            for (Map.Entry<String, Model> stringModelEntry : this.processAllModules ? reactor.entrySet() : PomHelper.getChildModels(reactor, sourceGroupId, sourceArtifactId).entrySet()) {
                Model targetModel = stringModelEntry.getValue();
                Parent parent = targetModel.getParent();
                this.getLog().debug((CharSequence)("Module: " + stringModelEntry.getKey()));
                if (parent != null && sourceVersion.equals(parent.getVersion())) {
                    this.getLog().debug((CharSequence)("    parent already is " + ArtifactUtils.versionlessKey((String)sourceGroupId, (String)sourceArtifactId) + ":" + sourceVersion));
                } else {
                    this.getLog().debug((CharSequence)("    parent is " + ArtifactUtils.versionlessKey((String)sourceGroupId, (String)sourceArtifactId) + ":" + (parent == null ? "" : parent.getVersion())));
                    this.getLog().debug((CharSequence)("    will become " + ArtifactUtils.versionlessKey((String)sourceGroupId, (String)sourceArtifactId) + ":" + sourceVersion));
                }
                boolean targetExplicit = PomHelper.isExplicitVersion(targetModel);
                if ((this.updateMatchingVersions || !targetExplicit) && parent != null && StringUtils.equals((String)parent.getVersion(), (String)PomHelper.getVersion(targetModel))) {
                    this.getLog().debug((CharSequence)("    module is " + ArtifactUtils.versionlessKey((String)PomHelper.getGroupId(targetModel), (String)PomHelper.getArtifactId(targetModel)) + ":" + PomHelper.getVersion(targetModel)));
                    this.getLog().debug((CharSequence)("    will become " + ArtifactUtils.versionlessKey((String)PomHelper.getGroupId(targetModel), (String)PomHelper.getArtifactId(targetModel)) + ":" + sourceVersion));
                    this.addChange(PomHelper.getGroupId(targetModel), PomHelper.getArtifactId(targetModel), PomHelper.getVersion(targetModel), sourceVersion);
                    targetModel.setVersion(sourceVersion);
                    continue;
                }
                this.getLog().debug((CharSequence)("    module is " + ArtifactUtils.versionlessKey((String)PomHelper.getGroupId(targetModel), (String)PomHelper.getArtifactId(targetModel)) + ":" + PomHelper.getVersion(targetModel)));
            }
        }
    }

    private void addFile(Set<File> files, MavenProject project, String relativePath) {
        File moduleDir = new File(project.getBasedir(), relativePath);
        File projectBaseDir = project.getBasedir();
        File moduleProjectFile = projectBaseDir.equals(moduleDir) ? project.getFile() : (moduleDir.isDirectory() ? new File(moduleDir, "pom.xml") : moduleDir);
        files.add(moduleProjectFile);
    }

    @Override
    protected synchronized void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        DelegatingContextualLog log = new DelegatingContextualLog(this.getLog());
        try {
            Model model = PomHelper.getRawModel(pom);
            log.setContext("Processing " + PomHelper.getGroupId(model) + ":" + PomHelper.getArtifactId(model));
            VersionChangerFactory versionChangerFactory = new VersionChangerFactory();
            versionChangerFactory.setPom(pom);
            versionChangerFactory.setLog(log);
            versionChangerFactory.setModel(model);
            VersionChanger changer = versionChangerFactory.newVersionChanger(this.processParent, this.processProject, this.processDependencies, this.processPlugins);
            for (VersionChange versionChange : this.sourceChanges) {
                changer.apply(versionChange);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        log.clearContext();
    }
}

