/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.unix.maven.zip;

import fj.F;
import fj.F2;
import fj.F3;
import fj.Function;
import fj.data.List;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.codehaus.mojo.unix.BasicPackageFileSystemObject;
import org.codehaus.mojo.unix.FileAttributes;
import org.codehaus.mojo.unix.FileCollector;
import org.codehaus.mojo.unix.PackageFileSystem;
import org.codehaus.mojo.unix.PackageFileSystemObject;
import org.codehaus.mojo.unix.PackageParameters;
import org.codehaus.mojo.unix.UnixFsObject;
import org.codehaus.mojo.unix.UnixPackage;
import org.codehaus.mojo.unix.java.BooleanF;
import org.codehaus.mojo.unix.util.RelativePath;
import org.codehaus.mojo.unix.util.ScriptUtil;
import org.codehaus.plexus.util.IOUtil;
import org.joda.time.LocalDateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipUnixPackage
extends UnixPackage {
    private PackageFileSystem<F2<UnixFsObject, ZipOutputStream, Callable>> fileSystem;
    private FileObject workingDirectory;
    private final F2<UnixFsObject, ZipOutputStream, Callable> directory = new F2<UnixFsObject, ZipOutputStream, Callable>(){

        public Callable f(final UnixFsObject unixFsObject, final ZipOutputStream zipOutputStream) {
            return new Callable(){

                public Object call() throws Exception {
                    String path = unixFsObject.path.isBase() ? "." : unixFsObject.path.asAbsolutePath("./") + "/";
                    zipOutputStream.putNextEntry(new ZipEntry(path));
                    return null;
                }
            };
        }
    };
    private final F3<FileObject, UnixFsObject, ZipOutputStream, Callable> file = new F3<FileObject, UnixFsObject, ZipOutputStream, Callable>(){

        public Callable f(final FileObject fromFile, final UnixFsObject unixFsObject, final ZipOutputStream zipOutputStream) {
            return new Callable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object call() throws Exception {
                    UnixFsObject.RegularFile file = (UnixFsObject.RegularFile)unixFsObject;
                    ZipEntry zipEntry = new ZipEntry(unixFsObject.path.asAbsolutePath("./"));
                    zipEntry.setSize(file.size);
                    zipEntry.setTime(file.lastModified.toDateTime().getMillis());
                    zipOutputStream.putNextEntry(zipEntry);
                    InputStream inputStream = null;
                    try {
                        inputStream = fromFile.getContent().getInputStream();
                        IOUtil.copy((InputStream)inputStream, (OutputStream)zipOutputStream, (int)131072);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(inputStream);
                        throw throwable;
                    }
                    IOUtil.close((InputStream)inputStream);
                    return null;
                }
            };
        }
    };

    public ZipUnixPackage() {
        super("zip");
    }

    public UnixPackage parameters(PackageParameters parameters) {
        return this;
    }

    public FileObject getRoot() {
        return this.workingDirectory;
    }

    public FileCollector addDirectory(UnixFsObject.Directory directory) throws IOException {
        BasicPackageFileSystemObject o = new BasicPackageFileSystemObject((UnixFsObject)directory, this.directory);
        this.fileSystem = this.fileSystem.addDirectory((PackageFileSystemObject)o);
        return this;
    }

    public FileCollector addFile(FileObject fromFile, UnixFsObject.RegularFile file) throws IOException {
        F2 f = Function.uncurryF2((F)Function.curry(this.file, (Object)fromFile));
        BasicPackageFileSystemObject o = new BasicPackageFileSystemObject((UnixFsObject)file, (Object)f);
        this.fileSystem = this.fileSystem.addFile((PackageFileSystemObject)o);
        return this;
    }

    public FileCollector addSymlink(UnixFsObject.Symlink symlink) throws IOException {
        return this;
    }

    public void apply(F2<UnixFsObject, FileAttributes, FileAttributes> f) {
        this.fileSystem = this.fileSystem.apply(f);
    }

    public ZipUnixPackage workingDirectory(FileObject workingDirectory) throws FileSystemException {
        this.workingDirectory = workingDirectory;
        return this;
    }

    public void beforeAssembly(FileAttributes defaultDirectoryAttributes) throws IOException {
        UnixFsObject.Directory rootDirectory = UnixFsObject.directory((RelativePath)RelativePath.BASE, (LocalDateTime)new LocalDateTime(System.currentTimeMillis()), (FileAttributes)FileAttributes.EMPTY);
        BasicPackageFileSystemObject fileSystemObject = new BasicPackageFileSystemObject((UnixFsObject)rootDirectory, this.directory);
        this.fileSystem = PackageFileSystem.create((PackageFileSystemObject)fileSystemObject, (PackageFileSystemObject)fileSystemObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void packageToFile(File packageFile, ScriptUtil.Strategy strategy) throws Exception {
        F2 pathFilter = ZipUnixPackage.pathFilter();
        List items = this.fileSystem.toList().filter(Function.compose((F)BooleanF.invert, (F)Function.curry(pathFilter, (Object)RelativePath.BASE)));
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(packageFile));
            for (PackageFileSystemObject fileSystemObject : items) {
                ((Callable)((F2)fileSystemObject.getExtension()).f((Object)fileSystemObject.getUnixFsObject(), (Object)zos)).call();
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(zos);
            throw throwable;
        }
        IOUtil.close((OutputStream)zos);
    }

    public static <A> F2<RelativePath, PackageFileSystemObject<A>, Boolean> pathFilter() {
        return new F2<RelativePath, PackageFileSystemObject<A>, Boolean>(){

            public Boolean f(RelativePath path, PackageFileSystemObject object) {
                return object.getUnixFsObject().path.equals((Object)path);
            }
        };
    }
}

