/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.shell;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.codehaus.mojo.tools.cli.CommandLineManager;
import org.codehaus.mojo.tools.project.extras.ArtifactPathResolver;
import org.codehaus.mojo.tools.project.extras.DependencyPathResolver;
import org.codehaus.mojo.tools.project.extras.PathResolutionException;
import org.codehaus.mojo.tools.project.extras.PrefixPropertyPathResolver;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.cli.shell.BourneShell;
import org.codehaus.plexus.util.cli.shell.Shell;

public class ShellExecMojo
extends AbstractMojo {
    private boolean keepScriptFile;
    private MavenProject project;
    private Set<Artifact> testArtifacts;
    private File workDir;
    private boolean chmod;
    private String script;
    private File executable;
    private boolean trimScript;
    private String extension;
    private boolean debug;
    private List<ArtifactRepository> remoteRepositories;
    private List<ArtifactRepository> remotePluginRepositories;
    private ArtifactRepository localRepository;
    private boolean skipPomProjects;
    private MavenProjectBuilder projectBuilder;
    private ArtifactFactory artifactFactory;
    private CommandLineManager cliManager;

    public void execute() throws MojoExecutionException {
        if (this.skipPomProjects && "pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping POM project, per configuration.");
            return;
        }
        this.workDir.mkdirs();
        try {
            this.createExecutable();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create shell script. Reason: " + e.getMessage(), (Exception)e);
        }
        if (this.chmod) {
            this.doChmod();
        }
        Commandline exec = new Commandline();
        exec.setShell((Shell)new BourneShell(true));
        exec.setWorkingDirectory(this.workDir.getAbsolutePath());
        exec.setExecutable(this.executable.getAbsolutePath());
        try {
            StreamConsumer consumer = this.cliManager.newInfoStreamConsumer();
            int result = this.cliManager.execute(exec, consumer, consumer);
            if (result != 0) {
                throw new MojoExecutionException("Script failed to execute (exit value != 0). Please see output above for more information.");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Failed to execute embedded shell script. Reason: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    protected final void setChmodUsed(boolean chmodUsed) {
        this.chmod = chmodUsed;
    }

    private void createExecutable() throws IOException, MojoExecutionException {
        this.executable = File.createTempFile("maven-shell-plugin-", this.extension);
        if (this.debug || this.getLog().isDebugEnabled() || this.keepScriptFile) {
            this.getLog().info((CharSequence)("NOT deleting generated script file: " + this.executable.getAbsolutePath()));
        } else {
            this.executable.deleteOnExit();
        }
        FileWriter writer = null;
        String output = this.script;
        if (this.trimScript) {
            output = this.script.trim();
        }
        try {
            writer = new FileWriter(this.executable);
            ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>();
            repositories.addAll(this.remoteRepositories);
            repositories.addAll(this.remotePluginRepositories);
            PrefixPropertyPathResolver pathResolver = new PrefixPropertyPathResolver(this.projectBuilder, repositories, this.localRepository, this.artifactFactory, this.getLog());
            DependencyPathResolver resolver = new DependencyPathResolver(this.testArtifacts, (ArtifactPathResolver)pathResolver, this.getLog());
            output = resolver.resolveDependencyPaths(output);
            writer.write(output);
        }
        catch (PathResolutionException e) {
            try {
                throw new MojoExecutionException("Error resolving dependency paths for: " + output + ". Reason: " + e.getMessage(), (Exception)((Object)e));
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
    }

    private void doChmod() throws MojoExecutionException {
        Commandline chmodcmd = new Commandline();
        chmodcmd.setExecutable("chmod");
        chmodcmd.createArg().setLine("+x");
        chmodcmd.createArg().setLine(this.executable.getAbsolutePath());
        StreamConsumer consumer = this.cliManager.newDebugStreamConsumer();
        try {
            int result = this.cliManager.execute(chmodcmd, consumer, consumer);
            if (result != 0) {
                throw new MojoExecutionException("Failed to chmod script file (exit value != 0). Please see debug output for more information.");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Failed to chmod +x: " + this.executable + ". Reason: " + e.getMessage(), (Exception)((Object)e));
        }
    }
}

