/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tools.platform;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.mojo.tools.platform.PlatformDetectionException;
import org.codehaus.mojo.tools.platform.SystemDistributionDetector;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;

public class LinuxReleaseFileDistributionDetector
implements SystemDistributionDetector,
LogEnabled {
    public static final String ROLE_HINT = "linux-release-file";
    public static final File FEDORA_CORE_RELEASE_FILE = new File("/etc/fedora-release");
    public static final File REDHAT_RELEASE_FILE = new File("/etc/redhat-release");
    public static final File GENTOO_RELEASE_FILE = new File("/etc/gentoo-release");
    public static final File UBUNTU_RELEASE_FILE = new File("/etc/lsb-release");
    public static final File DEBIAN_RELEASE_FILE = new File("/etc/debian_version");
    public static final File CENTOS_RELEASE_FILE = new File("/etc/redhat-release");
    private static final List<File> LINUX_RELEASE_FILES = new ArrayList<File>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(FEDORA_CORE_RELEASE_FILE);
            this.add(REDHAT_RELEASE_FILE);
            this.add(GENTOO_RELEASE_FILE);
            this.add(UBUNTU_RELEASE_FILE);
            this.add(DEBIAN_RELEASE_FILE);
            this.add(CENTOS_RELEASE_FILE);
        }
    };
    private File releaseFile;
    private Logger logger;

    public String getDistributionInfo() throws PlatformDetectionException {
        try {
            String content = FileUtils.fileRead((File)this.releaseFile);
            this.getLogger().debug("Contents of Linux release-file: " + this.releaseFile.getAbsolutePath() + ":\n'" + content + "'");
            return content;
        }
        catch (IOException e) {
            throw new PlatformDetectionException("Failed to read contents of platform-release file.");
        }
    }

    public String getDistributionInfoSource() throws PlatformDetectionException {
        File tmpFile = this.getReleaseFile();
        if (tmpFile == null) {
            throw new PlatformDetectionException("Cannot detect any Linux release files.");
        }
        String source = tmpFile.getName();
        this.getLogger().debug("Got distribution information source: '" + source + "'.");
        return source;
    }

    public boolean isEnabled() {
        if ("Linux".equals(System.getProperty("os.name"))) {
            return this.getReleaseFile() != null;
        }
        return false;
    }

    private File getReleaseFile() {
        if (this.releaseFile == null) {
            this.getLogger().debug("Checking for Linux release files:");
            for (File tmpFile : LINUX_RELEASE_FILES) {
                this.getLogger().debug("Checking " + tmpFile.getAbsolutePath() + "...");
                if (tmpFile.exists()) {
                    this.getLogger().debug("found it.");
                    this.releaseFile = tmpFile;
                    break;
                }
                this.getLogger().debug("not found.");
            }
        }
        return this.releaseFile;
    }

    public void enableLogging(Logger log) {
        this.logger = log;
    }

    protected Logger getLogger() {
        return this.logger;
    }
}

