/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.mojo.rpm.RpmAttachedArtifactHandler;
import org.codehaus.mojo.tools.rpm.RpmFormattingException;
import org.codehaus.mojo.tools.rpm.RpmInfoFormatter;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;

public class ProjectRpmFileManager
implements LogEnabled {
    private RpmInfoFormatter rpmInfoFormatter;
    private Logger logger;

    public void formatAndSetProjectArtifactFile(MavenProject project, MavenProjectHelper projectHelper, File topDir, String rpmBaseName, boolean skipPlatformPostfix) throws MojoExecutionException {
        String classifier;
        File rpmsDir;
        String myArch;
        try {
            myArch = skipPlatformPostfix ? "noarch" : this.rpmInfoFormatter.formatPlatformArchitecture();
            rpmsDir = new File(topDir, "RPMS/" + myArch);
            classifier = skipPlatformPostfix ? myArch : this.rpmInfoFormatter.formatRPMPlatformName() + "." + myArch;
        }
        catch (RpmFormattingException e) {
            throw new MojoExecutionException("Cannot format OS architecture name for RPM directory structure.", (Exception)e);
        }
        File artifactFile = new File(rpmsDir, rpmBaseName + "." + myArch + ".rpm");
        this.setProjectArtifactFile(project, projectHelper, classifier, myArch, artifactFile);
    }

    public void setProjectArtifactFile(MavenProject project, MavenProjectHelper projectHelper, String classifier, String myArch, File artifactFile) {
        this.getLogger().info("Attatching artifact classifier :" + classifier + ": name :" + artifactFile);
        projectHelper.attachArtifact(project, "rpm", classifier, artifactFile);
        RpmAttachedArtifactHandler myHdlr = new RpmAttachedArtifactHandler(classifier, myArch);
        List attachedList = project.getAttachedArtifacts();
        for (Artifact artifact : attachedList) {
            if (artifact.getType() != "rpm") continue;
            artifact.setArtifactHandler((ArtifactHandler)myHdlr);
        }
    }

    public void enableLogging(Logger log) {
        this.logger = log;
    }

    protected Logger getLogger() {
        return this.logger;
    }
}

