/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.tools.rpm.RpmFormattingException;
import org.codehaus.mojo.tools.rpm.RpmInfoFormatter;
import org.codehaus.mojo.tools.rpm.RpmInstallException;
import org.codehaus.mojo.tools.rpm.RpmMediator;
import org.codehaus.mojo.tools.rpm.RpmQueryException;

public abstract class AbstractRpmInstallMojo
extends AbstractMojo {
    private boolean useSudo;
    private String rpmDbPath;
    private boolean forceAllInstalls;
    private boolean noParentDirs;
    private RpmInfoFormatter rpmInfoFormatter;
    private RpmMediator rpmMediator;

    protected AbstractRpmInstallMojo() {
    }

    protected final void install(MavenProject project, boolean force) throws RpmFormattingException, RpmInstallException, MojoExecutionException {
        this.install(project, null, null, force);
    }

    protected final void install(MavenProject project, String rpmVersion, String release, boolean force) throws RpmFormattingException, RpmInstallException, MojoExecutionException {
        this.rpmMediator.setUseSudo(this.useSudo);
        this.rpmMediator.setNoParentDirs(this.noParentDirs);
        Artifact artifact = null;
        List attachedList = project.getAttachedArtifacts();
        for (Artifact artifactTemp : attachedList) {
            if (artifactTemp.getType() != "rpm") continue;
            artifact = artifactTemp;
        }
        Properties properties = project.getProperties();
        String dbPath = this.rpmDbPath;
        if (dbPath == null && properties != null) {
            dbPath = properties.getProperty("rpmDbPath");
            this.getLog().info((CharSequence)("Using RPM database path from POM: '" + dbPath + "'."));
        } else {
            this.getLog().info((CharSequence)("Using RPM database path from plugin parameter: '" + dbPath + "'."));
        }
        String rpmName = this.rpmInfoFormatter.formatRpmNameWithoutVersion(project);
        try {
            if (force || this.forceAllInstalls || !this.rpmMediator.isRpmInstalled(rpmName, rpmVersion, release, dbPath)) {
                this.rpmMediator.install(rpmName, artifact.getFile(), dbPath, force || this.forceAllInstalls);
            }
        }
        catch (RpmQueryException e) {
            throw new MojoExecutionException("Error querying for the existence of: " + rpmName + " in RPM database: " + dbPath);
        }
    }
}

