/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.plugin;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.mojo.natives.NativeSources;
import org.codehaus.mojo.natives.plugin.AbstractNativeMojo;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.archiver.zip.ZipArchiver;

public class NativeBundleIncludeFilesMojo
extends AbstractNativeMojo {
    private NativeSources[] sources = new NativeSources[0];
    private File incZipFile;
    private boolean skipIncludeDeployment;
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException {
        if (this.skipIncludeDeployment) {
            return;
        }
        if (this.sources.length != 0) {
            try {
                ZipArchiver archiver = new ZipArchiver();
                boolean zipIt = false;
                for (int i = 0; i < this.sources.length; ++i) {
                    if (!this.sources[i].isDeployable()) continue;
                    DefaultFileSet fileSet = new DefaultFileSet();
                    fileSet.setUsingDefaultExcludes(true);
                    fileSet.setDirectory(this.sources[i].getDirectory());
                    fileSet.setIncludes(this.sources[i].getIncludes());
                    fileSet.setExcludes(this.sources[i].getExcludes());
                    archiver.addFileSet((FileSet)fileSet);
                    zipIt = true;
                }
                if (zipIt) {
                    archiver.setDestFile(this.incZipFile);
                    archiver.createArchive();
                    this.projectHelper.attachArtifact(this.project, "inczip", null, this.incZipFile);
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
    }
}

