/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.mojo.mrm.api.DefaultDirectoryEntry;
import org.codehaus.mojo.mrm.api.DirectoryEntry;
import org.codehaus.mojo.mrm.api.Entry;
import org.codehaus.mojo.mrm.api.FileEntry;
import org.codehaus.mojo.mrm.api.FileSystem;
import org.codehaus.mojo.mrm.impl.MemoryFileSystem;
import org.codehaus.mojo.mrm.impl.Utils;

public class FileSystemServlet
extends HttpServlet {
    private static final int NAME_COL_WIDTH = 50;
    private static final int SIZE_COL_WIDTH = 20;
    private FileSystem fileSystem;

    public FileSystemServlet() {
        this.fileSystem = new MemoryFileSystem();
    }

    public FileSystemServlet(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String context;
        String path = req.getPathInfo();
        if (path == null) {
            path = req.getServletPath();
            context = req.getContextPath();
        } else {
            context = req.getContextPath() + req.getServletPath();
        }
        Entry entry = this.fileSystem.get(path);
        if (entry instanceof FileEntry) {
            FileEntry fileEntry = (FileEntry)entry;
            long size = fileEntry.getSize();
            if (size >= 0L && size < Integer.MAX_VALUE) {
                resp.setContentLength((int)size);
            }
            resp.setContentType(this.getServletContext().getMimeType(fileEntry.getName()));
            InputStream source = null;
            ServletOutputStream destination = null;
            try {
                source = fileEntry.getInputStream();
                destination = resp.getOutputStream();
                IOUtils.copy((InputStream)source, (OutputStream)destination);
            }
            finally {
                IOUtils.closeQuietly((InputStream)source);
                IOUtils.closeQuietly((OutputStream)destination);
            }
            return;
        }
        if (entry instanceof DirectoryEntry) {
            if (!path.endsWith("/")) {
                resp.sendRedirect(entry.getName() + "/");
                return;
            }
            DirectoryEntry dirEntry = (DirectoryEntry)entry;
            Entry[] entries = this.fileSystem.listEntries(dirEntry);
            resp.setContentType("text/html");
            PrintWriter w = resp.getWriter();
            w.println("<html>");
            w.println("  <head>");
            w.println("    <title>Index of " + context + path + "</title>");
            w.println("    <meta http-equiv=\"Content-Type\" repository=\"text/html; charset=utf-8\"/>");
            w.println("</head>");
            w.println("<body>");
            w.println("<h1>Index of " + context + path + "</h1>");
            w.println("  <hr/>");
            w.write("<pre>");
            if (dirEntry.getParent() != null) {
                w.println("<a href='../'>../</a>");
            }
            SimpleDateFormat format = new SimpleDateFormat("dd-MMM-yyyy hh:mm");
            if (entries != null) {
                for (int i = 0; i < entries.length; ++i) {
                    String childName = entries[i].getName();
                    boolean directory = entries[i] instanceof DirectoryEntry;
                    if (directory) {
                        String dirName = childName + "/";
                        w.write("<a href=\"./" + Utils.urlEncodePathSegment(childName) + "/\">" + FileSystemServlet.formatName(dirName) + "</a>" + StringUtils.repeat((String)" ", (int)Math.max(0, 50 - dirName.length())));
                    } else {
                        w.write("<a href=\"./" + Utils.urlEncodePathSegment(childName) + "\">" + FileSystemServlet.formatName(childName) + "</a>" + StringUtils.repeat((String)" ", (int)Math.max(0, 50 - childName.length())));
                    }
                    long timestamp = 0L;
                    try {
                        timestamp = entries[i].getLastModified();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    w.write(" ");
                    w.write(format.format(timestamp != -1L ? new Date(timestamp) : new Date()));
                    if (directory) {
                        w.println(StringUtils.leftPad((String)"-", (int)20));
                        continue;
                    }
                    if (entries[i] instanceof FileEntry) {
                        FileEntry fileEntry = (FileEntry)entries[i];
                        try {
                            long size = fileEntry.getSize();
                            if (size >= 0L) {
                                w.println(StringUtils.leftPad((String)Long.toString(size), (int)20));
                                continue;
                            }
                            w.println(StringUtils.leftPad((String)"-", (int)20));
                        }
                        catch (IOException e) {
                            w.println(StringUtils.leftPad((String)"-", (int)20));
                        }
                        continue;
                    }
                    w.println(StringUtils.leftPad((String)"-", (int)20));
                }
            }
            w.write("</pre>");
            w.println("  <hr/>");
            w.println("</body>");
            w.println("</html>");
            return;
        }
        resp.sendError(404);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String[] parts;
        String context;
        String path = req.getPathInfo();
        if (path == null) {
            path = req.getServletPath();
            context = req.getContextPath();
        } else {
            context = req.getContextPath() + req.getServletPath();
        }
        if (path.endsWith("/")) {
            resp.sendError(405);
            return;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((parts = path.split("/")).length == 0) {
            resp.sendError(405);
            return;
        }
        String name = parts[parts.length - 1];
        if (StringUtils.isEmpty((String)name)) {
            resp.sendError(405);
            return;
        }
        DirectoryEntry parent = this.fileSystem.getRoot();
        for (int i = 0; i < parts.length - 1; ++i) {
            parent = new DefaultDirectoryEntry(this.fileSystem, parent, parts[i]);
        }
        ServletInputStream inputStream = null;
        try {
            inputStream = req.getInputStream();
            FileEntry put = this.fileSystem.put(parent, name, (InputStream)inputStream);
            if (put != null) {
                resp.setStatus(200);
                return;
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        resp.sendError(405);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getPathInfo();
        if (path == null) {
            path = req.getServletPath();
            String context = req.getContextPath();
        } else {
            String context = req.getContextPath() + req.getServletPath();
        }
        Entry entry = this.fileSystem.get(path);
        if (entry == null) {
            resp.setStatus(200);
            return;
        }
        try {
            this.fileSystem.remove(entry);
            resp.setStatus(200);
        }
        catch (UnsupportedOperationException e) {
            resp.sendError(405);
        }
    }

    private static String formatName(String name) {
        if (name.length() < 50) {
            return name;
        }
        return name.substring(0, 49) + ">";
    }
}

