/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.spdx;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.codehaus.mojo.license.spdx.SpdxLicenseInfo;
import org.codehaus.mojo.license.spdx.SpdxLicenseListData;

public class SpdxLicenseList {
    private static volatile SpdxLicenseList latest;
    private static final Object LOCK;
    private final String licenseListVersion;
    private final String releaseDate;
    private final Map<String, SpdxLicenseInfo> licenses;
    private final Attachments attachments;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpdxLicenseList getLatest() {
        if (latest == null) {
            Object object = LOCK;
            synchronized (object) {
                if (latest == null) {
                    latest = SpdxLicenseListData.createList();
                }
            }
        }
        return latest;
    }

    public static Builder builder() {
        return new Builder();
    }

    SpdxLicenseList(String licenseListVersion, Map<String, SpdxLicenseInfo> licenses, String releaseDate, Attachments attachments) {
        this.licenseListVersion = licenseListVersion;
        this.licenses = licenses;
        this.releaseDate = releaseDate;
        this.attachments = attachments;
    }

    public String getLicenseListVersion() {
        return this.licenseListVersion;
    }

    public Map<String, SpdxLicenseInfo> getLicenses() {
        return this.licenses;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public Attachments getAttachments() {
        return this.attachments;
    }

    static {
        LOCK = new Object();
    }

    public static class Builder {
        private String licenseListVersion;
        private String releaseDate;
        private Map<String, SpdxLicenseInfo> licenses = new LinkedHashMap<String, SpdxLicenseInfo>();
        private Map<String, Attachments.ContentSanitizer> contentSanitizers = new TreeMap<String, Attachments.ContentSanitizer>();
        private Map<String, Attachments.UrlReplacement> urlReplacements = new TreeMap<String, Attachments.UrlReplacement>();

        public SpdxLicenseList build() {
            Objects.requireNonNull(this.licenseListVersion, "isDeprecatedLicenseId");
            Objects.requireNonNull(this.releaseDate, "detailsUrl");
            if (this.licenses.isEmpty()) {
                throw new IllegalStateException("licenses cannot be empty");
            }
            Map<String, SpdxLicenseInfo> lics = Collections.unmodifiableMap(this.licenses);
            this.licenses = null;
            Map<String, Attachments.ContentSanitizer> sanitizers = Collections.unmodifiableMap(this.contentSanitizers);
            this.contentSanitizers = null;
            Map<String, Attachments.UrlReplacement> replacements = Collections.unmodifiableMap(this.urlReplacements);
            this.urlReplacements = null;
            return new SpdxLicenseList(this.licenseListVersion, lics, this.releaseDate, new Attachments(sanitizers, replacements));
        }

        public Builder licenseListVersion(String licenseListVersion) {
            this.licenseListVersion = licenseListVersion;
            return this;
        }

        public Builder releaseDate(String releaseDate) {
            this.releaseDate = releaseDate;
            return this;
        }

        public Builder license(SpdxLicenseInfo license) {
            this.licenses.put(license.getLicenseId(), license);
            return this;
        }

        public Builder contentSanitizer(String id, String urlPattern, String contentPattern, String contentReplacement) {
            this.contentSanitizers.put(id, Attachments.ContentSanitizer.compile(id, urlPattern, contentPattern, contentReplacement));
            return this;
        }

        public Builder urlReplacement(String id, String urlPattern, String replacement) {
            this.urlReplacements.put(id, Attachments.UrlReplacement.compile(id, urlPattern, replacement));
            return this;
        }
    }

    public static class Attachments {
        private final Map<String, ContentSanitizer> contentSanitizers;
        private final Map<String, UrlReplacement> urlReplacements;

        Attachments(Map<String, ContentSanitizer> contentSanitizers, Map<String, UrlReplacement> urlReplacements) {
            this.contentSanitizers = contentSanitizers;
            this.urlReplacements = urlReplacements;
        }

        public Map<String, ContentSanitizer> getContentSanitizers() {
            return this.contentSanitizers;
        }

        public Map<String, UrlReplacement> getUrlReplacements() {
            return this.urlReplacements;
        }

        public static class ContentSanitizer {
            private final String id;
            private final Pattern urlPattern;
            private final Pattern contentPattern;
            private final String contentReplacement;

            public static ContentSanitizer compile(String id, String urlPattern, String contentPattern, String contentReplacement) {
                Objects.requireNonNull(id, "id");
                Objects.requireNonNull(urlPattern, "urlPattern");
                Objects.requireNonNull(contentPattern, "contentPattern");
                contentReplacement = contentReplacement == null ? "" : contentReplacement;
                contentReplacement = StringEscapeUtils.unescapeJava((String)contentReplacement);
                return new ContentSanitizer(id, Pattern.compile(urlPattern, 2), Pattern.compile(contentPattern, 2), contentReplacement);
            }

            public ContentSanitizer(String id, Pattern urlPattern, Pattern contentPattern, String contentReplacement) {
                Objects.requireNonNull(id, "id");
                Objects.requireNonNull(urlPattern, "urlPattern");
                Objects.requireNonNull(contentPattern, "contentPattern");
                Objects.requireNonNull(contentReplacement, "contentReplacement");
                this.id = id;
                this.urlPattern = urlPattern;
                this.contentPattern = contentPattern;
                this.contentReplacement = contentReplacement;
            }

            public boolean applies(String url) {
                return this.urlPattern.matcher(url).matches();
            }

            public String sanitize(String content) {
                if (content == null) {
                    return null;
                }
                return this.contentPattern.matcher(content).replaceAll(this.contentReplacement);
            }

            public String getId() {
                return this.id;
            }

            public Pattern getUrlPattern() {
                return this.urlPattern;
            }

            public Pattern getContentPattern() {
                return this.contentPattern;
            }

            public String getContentReplacement() {
                return this.contentReplacement;
            }
        }

        public static class UrlReplacement {
            private final String id;
            private final Pattern urlPattern;
            private final String replacement;

            public static UrlReplacement compile(String id, String urlPattern, String replacement) {
                Objects.requireNonNull(id, "id");
                Objects.requireNonNull(urlPattern, "urlPattern");
                replacement = replacement == null ? "" : replacement;
                return new UrlReplacement(id, Pattern.compile(urlPattern, 2), replacement);
            }

            public UrlReplacement(String id, Pattern urlPattern, String replacement) {
                this.id = id;
                this.urlPattern = urlPattern;
                this.replacement = replacement;
            }

            public String getId() {
                return this.id;
            }

            public Pattern getUrlPattern() {
                return this.urlPattern;
            }

            public String getReplacement() {
                return this.replacement;
            }
        }
    }
}

