/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.model;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.mojo.license.model.License;
import org.codehaus.mojo.license.utils.MojoHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseRepository
implements Iterable<License> {
    private static final Log LOG = LogFactory.getLog(LicenseRepository.class);
    public static final String REPOSITORY_DEFINITION_FILE = "licenses.properties";
    public static final Pattern LICENSE_DESCRIPTION_PATTERN = Pattern.compile("(.*)\\s*~~\\s*license\\s*:\\s*(.*)\\s*~~\\s*header\\s*:\\s*(.*)\\s*");
    protected URL baseURL;
    protected List<License> licenses;
    protected boolean init;

    public URL getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(URL baseURL) {
        this.checkNotInit("setBaseURL");
        this.baseURL = baseURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        this.checkNotInit("load");
        try {
            if (this.baseURL == null || StringUtils.isEmpty((String)this.baseURL.toString())) {
                throw new IllegalStateException("no baseURL defined in " + this);
            }
            URL definitionURL = MojoHelper.getUrl(this.getBaseURL(), REPOSITORY_DEFINITION_FILE);
            if (this.licenses != null) {
                this.licenses.clear();
            } else {
                this.licenses = new ArrayList<License>();
            }
            if (!this.checkExists(definitionURL)) {
                throw new IllegalArgumentException("no licenses.properties found with url [" + definitionURL + "] for resolver " + this);
            }
            Properties p = new Properties();
            p.load(definitionURL.openStream());
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String headerFile;
                String licenseFile;
                String licenseName = (String)entry.getKey();
                licenseName = licenseName.trim().toLowerCase();
                URL licenseBaseURL = MojoHelper.getUrl(this.baseURL, licenseName);
                License license = new License();
                license.setName(licenseName);
                license.setBaseURL(licenseBaseURL);
                String licenseDescription = (String)entry.getValue();
                Matcher matcher = LICENSE_DESCRIPTION_PATTERN.matcher(licenseDescription);
                if (matcher.matches()) {
                    licenseDescription = matcher.group(1);
                    licenseFile = matcher.group(2);
                    headerFile = matcher.group(3);
                } else {
                    licenseFile = "license.txt";
                    headerFile = "header.txt";
                }
                URL licenseURL = MojoHelper.getUrl(licenseBaseURL, licenseFile);
                if (!this.checkExists(licenseURL)) {
                    throw new IllegalArgumentException("Could not find license (" + license + ") content file at [" + licenseURL + "] for resolver " + this);
                }
                license.setLicenseURL(licenseURL);
                URL headerURL = MojoHelper.getUrl(licenseBaseURL, headerFile);
                if (!this.checkExists(headerURL)) {
                    throw new IllegalArgumentException("Could not find license (" + license + ") header file at [" + headerURL + "] for resolver " + this);
                }
                license.setHeaderURL(headerURL);
                license.setDescription(licenseDescription);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("register " + license.getDescription()));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)license);
                }
                this.licenses.add(license);
            }
            this.licenses = Collections.unmodifiableList(this.licenses);
        }
        finally {
            this.init = true;
        }
    }

    public String[] getLicenseNames() {
        this.checkInit("getLicenseNames");
        ArrayList<String> result = new ArrayList<String>(this.licenses.size());
        for (License license : this) {
            result.add(license.getName());
        }
        return result.toArray(new String[result.size()]);
    }

    public License[] getLicenses() {
        this.checkInit("getLicenses");
        return this.licenses.toArray(new License[this.licenses.size()]);
    }

    public License getLicense(String licenseName) {
        this.checkInit("getLicense");
        if (StringUtils.isEmpty((String)licenseName)) {
            throw new IllegalArgumentException("licenceName can not be null, nor empty");
        }
        License license = null;
        for (License l : this) {
            if (!licenseName.equals(l.getName())) continue;
            license = l;
            break;
        }
        return license;
    }

    @Override
    public Iterator<License> iterator() {
        this.checkInit("iterator");
        return this.licenses.iterator();
    }

    protected boolean checkExists(URL url) throws IOException {
        URLConnection openConnection = url.openConnection();
        return openConnection.getContentLength() > 0;
    }

    protected void checkInit(String operation) {
        if (!this.init) {
            throw new IllegalStateException("repository " + this + " was not init, operation [" + operation + "] not possible.");
        }
    }

    protected void checkNotInit(String operation) {
        if (this.init) {
            throw new IllegalStateException("repository " + this + "was init, operation [" + operation + "+] not possible.");
        }
    }
}

