/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.header.transformer;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.codehaus.mojo.license.header.FileHeader;
import org.codehaus.mojo.license.header.transformer.FileHeaderTransformer;

public abstract class AbstractFileHeaderTransformer
implements FileHeaderTransformer {
    protected static final Pattern COPYRIGHT_PATTERN = Pattern.compile("(.[^\\d]+)?\\s(\\d{4})?(\\s+-\\s+(\\d{4})?){0,1}\\s+(.+)?", 32);
    protected String name;
    protected String description;
    protected String sectionDelimiter = "%%";
    protected String processStartTag = "#%L";
    protected String processEndTag = "#L%";
    protected String commentStartTag;
    protected String commentEndTag;
    protected String commentLinePrefix;
    protected static final Pattern REMOVE_SPACE_PATTERN = Pattern.compile("(\\s+)");

    protected AbstractFileHeaderTransformer(String name, String description, String commentStartTag, String commentEndTag, String commentLinePrefix) {
        this.name = name;
        this.description = description;
        if (commentStartTag.equals(commentLinePrefix)) {
            throw new IllegalStateException("commentStartTag can not be equals to commentPrefixLine, but was [" + commentStartTag + "]");
        }
        if (commentEndTag.equals(commentLinePrefix)) {
            throw new IllegalStateException("commentEndTag can not be equals to commentPrefixLine, but was [" + commentEndTag + "]");
        }
        this.commentStartTag = commentStartTag;
        this.commentEndTag = commentEndTag;
        this.commentLinePrefix = commentLinePrefix;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSectionDelimiter() {
        return this.sectionDelimiter;
    }

    public void setSectionDelimiter(String sectionDelimiter) {
        this.sectionDelimiter = sectionDelimiter;
    }

    public String getProcessStartTag() {
        return this.processStartTag;
    }

    public void setProcessStartTag(String processStartTag) {
        this.processStartTag = processStartTag;
    }

    public String getProcessEndTag() {
        return this.processEndTag;
    }

    public void setProcessEndTag(String processEndTag) {
        this.processEndTag = processEndTag;
    }

    public String getCommentStartTag() {
        return this.commentStartTag;
    }

    public void setCommentStartTag(String commentStartTag) {
        this.commentStartTag = commentStartTag;
    }

    public String getCommentEndTag() {
        return this.commentEndTag;
    }

    public void setCommentEndTag(String commentEndTag) {
        this.commentEndTag = commentEndTag;
    }

    public String getCommentLinePrefix() {
        return this.commentLinePrefix;
    }

    public String addHeader(String header, String content) {
        return header + content;
    }

    public void setCommentLinePrefix(String commentLinePrefix) {
        this.commentLinePrefix = commentLinePrefix;
    }

    public FileHeader toFileHeader(String header) {
        FileHeader model = new FileHeader();
        String[] sections = header.split(this.getSectionDelimiter());
        if (sections.length != 3) {
            throw new IllegalStateException("could not find 3 sections in\n" + header);
        }
        String description = sections[0].trim();
        model.setDescription(description);
        String copyright = sections[1].trim();
        Matcher matcher = COPYRIGHT_PATTERN.matcher(copyright);
        if (!matcher.matches()) {
            throw new IllegalStateException("copyright [" + copyright + "] is not valid");
        }
        String firstYear = matcher.group(2);
        String lastYear = matcher.group(4);
        String holder = matcher.group(5);
        model.setCopyrightFirstYear(Integer.valueOf(firstYear.trim()));
        if (lastYear != null) {
            model.setCopyrightLastYear(Integer.valueOf(lastYear.trim()));
        }
        model.setCopyrightHolder(holder.trim());
        String license = sections[2].trim();
        model.setLicense(license);
        return model;
    }

    public String toString(FileHeader model) {
        if (model == null) {
            throw new NullPointerException("model can not be null!");
        }
        StringBuilder buffer = new StringBuilder();
        String sectionDelimiter = '\n' + this.getSectionDelimiter() + '\n';
        buffer.append(model.getDescription().trim());
        buffer.append(sectionDelimiter);
        buffer.append(model.getCopyright().trim());
        buffer.append(sectionDelimiter);
        buffer.append(model.getLicense().trim()).append('\n');
        return buffer.toString();
    }

    public String toHeaderContent(FileHeader model) {
        String result = this.toString(model);
        result = this.boxProcessTag(result);
        result = this.boxComment(result, false);
        int index = result.indexOf(this.getProcessStartTag());
        int lastIndex = result.lastIndexOf(this.getProcessEndTag()) + this.getProcessEndTag().length();
        result = result.substring(index, lastIndex);
        return result;
    }

    public String boxComment(String header, boolean withTags) {
        StringBuilder buffer = new StringBuilder();
        if (withTags) {
            buffer.append(this.getCommentStartTag()).append('\n');
        }
        for (String line : header.split("\n")) {
            buffer.append(this.getCommentLinePrefix());
            buffer.append(line);
            buffer.append('\n');
        }
        if (withTags) {
            buffer.append(this.getCommentEndTag()).append('\n');
        }
        return buffer.toString();
    }

    public String unboxComent(String header) {
        StringBuilder buffer = new StringBuilder();
        int prefixLength = this.getCommentLinePrefix().length();
        for (String line : header.split("\n")) {
            if (StringUtils.isEmpty((String)line) || line.contains(this.getCommentStartTag()) || line.contains(this.getCommentEndTag())) continue;
            int index = line.indexOf(this.getCommentLinePrefix());
            if (index > -1) {
                line = line.substring(index + prefixLength);
            } else {
                String s = this.getCommentLinePrefix().trim();
                if (line.startsWith(s)) {
                    if (line.length() <= s.length()) {
                        line = "";
                    }
                } else {
                    line = line.substring(s.length());
                }
            }
            buffer.append(line).append('\n');
        }
        return buffer.toString();
    }

    public String boxProcessTag(String header) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getProcessStartTag()).append('\n');
        buffer.append(header.trim()).append('\n');
        buffer.append(this.getProcessEndTag()).append('\n');
        return buffer.toString();
    }

    public String unboxProcessTag(String boxedHeader) {
        StringBuilder buffer = new StringBuilder();
        for (String line : boxedHeader.split("\n")) {
            if (StringUtils.isEmpty((String)line) || line.contains(this.getProcessStartTag()) || line.contains(this.getProcessEndTag())) continue;
            buffer.append(line).append('\n');
        }
        return buffer.toString();
    }

    public boolean isDescriptionEquals(FileHeader header1, FileHeader header2) {
        return header1.getDescription().equals(header2.getDescription());
    }

    public boolean isCopyrightEquals(FileHeader header1, FileHeader header2) {
        return header1.getCopyright().equals(header2.getCopyright());
    }

    public boolean isLicenseEquals(FileHeader header1, FileHeader header2) {
        String license1 = this.removeSpaces(header1.getLicense());
        String license2 = this.removeSpaces(header2.getLicense());
        return license1.equals(license2);
    }

    protected String removeSpaces(String str) {
        Matcher matcher = REMOVE_SPACE_PATTERN.matcher(str);
        String result = matcher.find() ? matcher.replaceAll("") : str;
        return result;
    }
}

