/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.mojo.license.AbstractAddThirdPartyMojo;
import org.codehaus.mojo.license.model.LicenseMap;
import org.codehaus.mojo.license.utils.SortedProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="aggregate-add-third-party", requiresProject=true, aggregator=true, defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
@Execute(goal="add-third-party")
public class AggregatorAddThirdPartyMojo
extends AbstractAddThirdPartyMojo {
    @Parameter(property="reactorProjects", readonly=true, required=true)
    protected List<?> reactorProjects;

    @Override
    protected boolean checkPackaging() {
        return this.acceptPackaging("pom");
    }

    @Override
    protected boolean checkSkip() {
        if (!this.isDoGenerate() && !this.isDoGenerateBundle()) {
            this.getLog().info((CharSequence)"All files are up to date, skip goal execution.");
            return false;
        }
        return super.checkSkip();
    }

    @Override
    protected void doAction() throws Exception {
        Log log = this.getLog();
        if (this.isVerbose()) {
            log.info((CharSequence)("After executing on " + this.reactorProjects.size() + " project(s)"));
        }
        SortedMap<String, MavenProject> artifacts = this.getHelper().getArtifactCache();
        LicenseMap licenseMap = this.getLicenseMap();
        this.getLog().info((CharSequence)(artifacts.size() + " detected artifact(s)."));
        if (this.isVerbose()) {
            for (String id : artifacts.keySet()) {
                this.getLog().info((CharSequence)(" - " + id));
            }
        }
        this.getLog().info((CharSequence)(licenseMap.size() + " detected license(s)."));
        if (this.isVerbose()) {
            for (String id : licenseMap.keySet()) {
                this.getLog().info((CharSequence)(" - " + id));
            }
        }
        boolean unsafe = this.checkUnsafeDependencies();
        boolean safeLicense = this.checkForbiddenLicenses();
        if (!safeLicense && this.isFailIfWarning()) {
            throw new MojoFailureException("There is some forbidden licenses used, please check your dependencies.");
        }
        this.writeThirdPartyFile();
        if (unsafe && this.isFailIfWarning()) {
            throw new MojoFailureException("There is some dependencies with no license, please review the modules.");
        }
    }

    @Override
    protected SortedMap<String, MavenProject> loadDependencies() {
        return this.getHelper().getArtifactCache();
    }

    @Override
    protected SortedProperties createUnsafeMapping() throws ProjectBuildingException, IOException {
        String path = this.getMissingFile().getAbsolutePath().substring(this.getProject().getBasedir().getAbsolutePath().length() + 1);
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Use missing file path : " + path));
        }
        SortedProperties unsafeMappings = new SortedProperties(this.getEncoding());
        LicenseMap licenseMap = this.getLicenseMap();
        for (Object o : this.reactorProjects) {
            SortedSet<MavenProject> unsafes;
            MavenProject p = (MavenProject)o;
            File file = new File(p.getBasedir(), path);
            if (file.exists()) {
                SortedProperties tmp = this.getHelper().loadUnsafeMapping(licenseMap, file);
                unsafeMappings.putAll((Map<?, ?>)tmp);
            }
            if (!CollectionUtils.isEmpty(unsafes = this.getHelper().getProjectsWithNoLicense(licenseMap))) continue;
            break;
        }
        return unsafeMappings;
    }
}

