/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.keytool;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.keytool.AbstractKeyToolMojo;
import org.codehaus.mojo.keytool.KeyTool;
import org.codehaus.mojo.keytool.KeyToolException;
import org.codehaus.mojo.keytool.KeyToolRequest;
import org.codehaus.mojo.keytool.KeyToolRequestWithKeyStoreAndAliasParameters;
import org.codehaus.mojo.keytool.KeyToolResult;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.Commandline;

public abstract class AbstractCmdLineKeyToolMojo
extends AbstractKeyToolMojo {
    private String storetype;
    private String storepass;
    private String alias;
    private String[] arguments;
    private boolean verbose;
    private KeyTool keyTool;

    protected abstract KeyToolRequestWithKeyStoreAndAliasParameters createRequest();

    public final void execute() throws MojoExecutionException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)this.getMessage("disabled"));
        } else {
            String keystoreFile = this.getKeystore();
            this.createParentDirIfNecessary(keystoreFile);
            KeyToolRequestWithKeyStoreAndAliasParameters request = this.createRequest();
            request.setWorkingDirectory(this.getWorkingDir());
            if (StringUtils.isNotEmpty((String)keystoreFile)) {
                request.setKeystore(keystoreFile);
            }
            request.setStoretype(this.storetype);
            request.setStorepass(this.storepass);
            request.setAlias(this.alias);
            request.setArguments(this.arguments);
            request.setVerbose(this.verbose);
            try {
                KeyToolResult result = this.keyTool.execute((KeyToolRequest)request);
                this.consumeResult(result);
            }
            catch (KeyToolException e) {
                throw new MojoExecutionException(this.getMessage("commandLineException", e.getMessage()), (Exception)((Object)e));
            }
        }
    }

    protected String getCommandlineInfo(Commandline commandLine) {
        if (commandLine == null) {
            throw new NullPointerException("commandLine");
        }
        String commandLineInfo = commandLine.toString();
        commandLineInfo = StringUtils.replace((String)commandLineInfo, (String)this.storepass, (String)"'*****'");
        return commandLineInfo;
    }

    protected void consumeResult(KeyToolResult result) throws MojoExecutionException {
        Commandline commandLine = result.getCommandline();
        int resultCode = result.getExitCode();
        if (resultCode != 0) {
            throw new MojoExecutionException(this.getMessage("failure", this.getCommandlineInfo(commandLine), new Integer(resultCode)));
        }
    }

    public void setStoretype(String storetype) {
        this.storetype = storetype;
    }

    public void setStorepass(String storepass) {
        this.storepass = storepass;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setArguments(String[] arguments) {
        this.arguments = arguments;
    }

    protected void setKeyTool(KeyTool keyTool) {
        this.keyTool = keyTool;
    }

    protected void createParentDirIfNecessary(String file) {
        File fileDir;
        if (file != null && (fileDir = new File(file).getParentFile()) != null) {
            boolean mkdirs = fileDir.mkdirs();
            this.getLog().debug((CharSequence)("mdkirs: " + mkdirs + " " + fileDir));
        }
    }
}

