/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jboss;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:jboss-maven-plugin:1.5.0", 0);
        this.append(sb, "", 0);
        this.append(sb, "JBoss Maven Plugin", 0);
        this.append(sb, "This plugin manages the ability start/stop JBoss and deploy/undeploy applications via JMX.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 14 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "configure".equals(this.goal)) {
            this.append(sb, "jboss:configure", 0);
            this.append(sb, "Allows you to configure JBoss installation by overlaying a conf, lib and deploy directory.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "confDir (Default: ${basedir}/jboss/conf)", 2);
                this.append(sb, "The directory for overrides to the conf directory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deployDir (Default: ${basedir}/jboss/deploy)", 2);
                this.append(sb, "The directory for overrides to the deploy directory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "javaOpts", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "jbossHome", 2);
                this.append(sb, "The location of JBoss Home. This is a required configuration parameter (unless JBOSS_HOME is set).", 3);
                this.append(sb, "", 0);
                this.append(sb, "libDir (Default: ${basedir}/jboss/lib)", 2);
                this.append(sb, "The directory for overrides to the lib directory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "options", 2);
                this.append(sb, "The set of options to pass to the JBoss 'run' command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/jboss)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "The id of the server configuration found in Maven settings.xml. This configuration will determine the username/password to use when authenticating with the JBoss server. If no value is specified, a default username and password will be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverName (Default: default)", 2);
                this.append(sb, "The name of the configuration profile to use when starting the server. This might be something like 'all', 'default', or 'minimal'.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "deploy".equals(this.goal)) {
            this.append(sb, "jboss:deploy", 0);
            this.append(sb, "Deploys a directory or file to JBoss via JMX.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "deployUrlPath", 2);
                this.append(sb, "The deployment URL path relative to the base URL path.", 3);
                this.append(sb, "", 0);
                this.append(sb, "fileNameEncoding (Default: UTF-8)", 2);
                this.append(sb, "The character encoding for the fileName.", 3);
                this.append(sb, "", 0);
                this.append(sb, "fileNames", 2);
                this.append(sb, "The name of the file or directory to deploy or undeploy.", 3);
                this.append(sb, "", 0);
                this.append(sb, "hostName (Default: localhost)", 2);
                this.append(sb, "The host JBoss is running on.", 3);
                this.append(sb, "", 0);
                this.append(sb, "port (Default: 8080)", 2);
                this.append(sb, "The port JBoss is running on.", 3);
                this.append(sb, "", 0);
                this.append(sb, "server", 2);
                this.append(sb, "Deprecated. Use serverId instead", 3);
                this.append(sb, "", 0);
                this.append(sb, "The id of the server configuration found in Maven settings.xml. This configuration will determine the username/password to use when authenticating with the JBoss server. If no value is specified, a default username and password will be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "The id of the server configuration found in Maven settings.xml. This configuration will determine the username/password to use when authenticating with the JBoss server. If no value is specified, a default username and password will be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip the mojo execution.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "hard-deploy".equals(this.goal)) {
            this.append(sb, "jboss:hard-deploy", 0);
            this.append(sb, "Hard deploys the file by copying it to the $JBOSS_HOME/server/[serverName]/deploy directory.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "deploySubDir", 2);
                this.append(sb, "An optional name of a subdirectory on the deploy directory to be used", 3);
                this.append(sb, "", 0);
                this.append(sb, "fileName (Default: ${project.build.directory}/${project.build.finalName}.${project.packaging})", 2);
                this.append(sb, "The name of the file or directory to deploy or undeploy.", 3);
                this.append(sb, "", 0);
                this.append(sb, "fileNames", 2);
                this.append(sb, "The names of the files or directories to deploy. If this is set, the fileName parameter will be ignored.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jbossHome", 2);
                this.append(sb, "The location of JBoss Home. This is a required configuration parameter (unless JBOSS_HOME is set).", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "The id of the server configuration found in Maven settings.xml. This configuration will determine the username/password to use when authenticating with the JBoss server. If no value is specified, a default username and password will be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverName (Default: default)", 2);
                this.append(sb, "The name of the configuration profile to use when starting the server. This might be something like 'all', 'default', or 'minimal'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "unpack (Default: false)", 2);
                this.append(sb, "A boolean indicating if the artifact should be unpacked when deployed", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "hard-undeploy".equals(this.goal)) {
            this.append(sb, "jboss:hard-undeploy", 0);
            this.append(sb, "Delete file form $JBOSS_HOME/server/[serverName]/deploy directory.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "fileName (Default: ${project.build.directory}/${project.build.finalName}.${project.packaging})", 2);
                this.append(sb, "The name of the file or directory to undeploy.", 3);
                this.append(sb, "", 0);
                this.append(sb, "fileNames", 2);
                this.append(sb, "The names of the files or directories to undeploy. If this is set, the fileName parameter will be ignored.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jbossHome", 2);
                this.append(sb, "The location of JBoss Home. This is a required configuration parameter (unless JBOSS_HOME is set).", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "The id of the server configuration found in Maven settings.xml. This configuration will determine the username/password to use when authenticating with the JBoss server. If no value is specified, a default username and password will be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverName (Default: default)", 2);
                this.append(sb, "The name of the configuration profile to use when starting the server. This might be something like 'all', 'default', or 'minimal'.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "harddeploy".equals(this.goal)) {
            this.append(sb, "jboss:harddeploy", 0);
            this.append(sb, "Deprecated. As of version 1.4, use the hard-deploy goal instead.", 1);
            if (this.detail) {
                this.append(sb, "", 0);
                this.append(sb, "Place holder to allow deprecated goal name to call hard-deploy.", 1);
            }
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "deploySubDir", 2);
                this.append(sb, "An optional name of a subdirectory on the deploy directory to be used", 3);
                this.append(sb, "", 0);
                this.append(sb, "fileName (Default: ${project.build.directory}/${project.build.finalName}.${project.packaging})", 2);
                this.append(sb, "The name of the file or directory to deploy or undeploy.", 3);
                this.append(sb, "", 0);
                this.append(sb, "fileNames", 2);
                this.append(sb, "The names of the files or directories to deploy. If this is set, the fileName parameter will be ignored.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jbossHome", 2);
                this.append(sb, "The location of JBoss Home. This is a required configuration parameter (unless JBOSS_HOME is set).", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "The id of the server configuration found in Maven settings.xml. This configuration will determine the username/password to use when authenticating with the JBoss server. If no value is specified, a default username and password will be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverName (Default: default)", 2);
                this.append(sb, "The name of the configuration profile to use when starting the server. This might be something like 'all', 'default', or 'minimal'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "unpack (Default: false)", 2);
                this.append(sb, "A boolean indicating if the artifact should be unpacked when deployed", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "hardundeploy".equals(this.goal)) {
            this.append(sb, "jboss:hardundeploy", 0);
            this.append(sb, "Deprecated. As of version 1.4, use the hard-undeploy goal instead.", 1);
            if (this.detail) {
                this.append(sb, "", 0);
                this.append(sb, "Place holder to allow deprecated goal name to call hard-undeploy.", 1);
            }
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "fileName (Default: ${project.build.directory}/${project.build.finalName}.${project.packaging})", 2);
                this.append(sb, "The name of the file or directory to undeploy.", 3);
                this.append(sb, "", 0);
                this.append(sb, "fileNames", 2);
                this.append(sb, "The names of the files or directories to undeploy. If this is set, the fileName parameter will be ignored.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jbossHome", 2);
                this.append(sb, "The location of JBoss Home. This is a required configuration parameter (unless JBOSS_HOME is set).", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "The id of the server configuration found in Maven settings.xml. This configuration will determine the username/password to use when authenticating with the JBoss server. If no value is specified, a default username and password will be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverName (Default: default)", 2);
                this.append(sb, "The name of the configuration profile to use when starting the server. This might be something like 'all', 'default', or 'minimal'.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "jboss:help", 0);
            this.append(sb, "Display help information on jboss-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0jboss:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "redeploy".equals(this.goal)) {
            this.append(sb, "jboss:redeploy", 0);
            this.append(sb, "ReDeploys a directory or file to JBoss via JMX.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "fileNames", 2);
                this.append(sb, "The name of the file or directory to deploy or undeploy.", 3);
                this.append(sb, "", 0);
                this.append(sb, "hostName (Default: localhost)", 2);
                this.append(sb, "The host JBoss is running on.", 3);
                this.append(sb, "", 0);
                this.append(sb, "port (Default: 8080)", 2);
                this.append(sb, "The port JBoss is running on.", 3);
                this.append(sb, "", 0);
                this.append(sb, "redeployUrlPath", 2);
                this.append(sb, "The redeployment URL.", 3);
                this.append(sb, "", 0);
                this.append(sb, "server", 2);
                this.append(sb, "Deprecated. Use serverId instead", 3);
                this.append(sb, "", 0);
                this.append(sb, "The id of the server configuration found in Maven settings.xml. This configuration will determine the username/password to use when authenticating with the JBoss server. If no value is specified, a default username and password will be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "The id of the server configuration found in Maven settings.xml. This configuration will determine the username/password to use when authenticating with the JBoss server. If no value is specified, a default username and password will be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip the mojo execution.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "start".equals(this.goal)) {
            this.append(sb, "jboss:start", 0);
            this.append(sb, "Starts JBoss.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "jbossHome", 2);
                this.append(sb, "The location of JBoss Home. This is a required configuration parameter (unless JBOSS_HOME is set).", 3);
                this.append(sb, "", 0);
                this.append(sb, "options", 2);
                this.append(sb, "Deprecated. use startOptions instead", 3);
                this.append(sb, "", 0);
                this.append(sb, "The set of options to pass to the JBoss 'run' command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "The id of the server configuration found in Maven settings.xml. This configuration will determine the username/password to use when authenticating with the JBoss server. If no value is specified, a default username and password will be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverName (Default: default)", 2);
                this.append(sb, "The name of the configuration profile to use when starting the server. This might be something like 'all', 'default', or 'minimal'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "startOptions", 2);
                this.append(sb, "The set of space separated options to pass to the JBoss 'run' command.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "start-and-wait".equals(this.goal)) {
            this.append(sb, "jboss:start-and-wait", 0);
            this.append(sb, "Starts JBoss and waits until the server is started.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "hostName (Default: localhost)", 2);
                this.append(sb, "The host JBoss is running on.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jbossHome", 2);
                this.append(sb, "The location of JBoss Home. This is a required configuration parameter (unless JBOSS_HOME is set).", 3);
                this.append(sb, "", 0);
                this.append(sb, "namingPort (Default: 1099)", 2);
                this.append(sb, "The port for the naming service.", 3);
                this.append(sb, "", 0);
                this.append(sb, "options", 2);
                this.append(sb, "Deprecated. use startOptions instead", 3);
                this.append(sb, "", 0);
                this.append(sb, "The set of options to pass to the JBoss 'run' command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "retry (Default: 4)", 2);
                this.append(sb, "Maximum number of retries to get JBoss JMX MBean connection.", 3);
                this.append(sb, "", 0);
                this.append(sb, "retryWait (Default: 5000)", 2);
                this.append(sb, "Wait in ms before each retry of the JBoss JMX MBean connection.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "The id of the server configuration found in Maven settings.xml. This configuration will determine the username/password to use when authenticating with the JBoss server. If no value is specified, a default username and password will be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverName (Default: default)", 2);
                this.append(sb, "The name of the configuration profile to use when starting the server. This might be something like 'all', 'default', or 'minimal'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "startOptions", 2);
                this.append(sb, "The set of space separated options to pass to the JBoss 'run' command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout (Default: 20000)", 2);
                this.append(sb, "Time in ms to start the application server (once JMX MBean connection has been reached).", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "startAndWait".equals(this.goal)) {
            this.append(sb, "jboss:startAndWait", 0);
            this.append(sb, "Deprecated. As of version 1.4, use the start-and-wait goal instead.", 1);
            if (this.detail) {
                this.append(sb, "", 0);
                this.append(sb, "Place holder to allow deprecated goal name to call start-and-wait.", 1);
            }
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "hostName (Default: localhost)", 2);
                this.append(sb, "The host JBoss is running on.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jbossHome", 2);
                this.append(sb, "The location of JBoss Home. This is a required configuration parameter (unless JBOSS_HOME is set).", 3);
                this.append(sb, "", 0);
                this.append(sb, "namingPort (Default: 1099)", 2);
                this.append(sb, "The port for the naming service.", 3);
                this.append(sb, "", 0);
                this.append(sb, "options", 2);
                this.append(sb, "Deprecated. use startOptions instead", 3);
                this.append(sb, "", 0);
                this.append(sb, "The set of options to pass to the JBoss 'run' command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "retry (Default: 4)", 2);
                this.append(sb, "Maximum number of retries to get JBoss JMX MBean connection.", 3);
                this.append(sb, "", 0);
                this.append(sb, "retryWait (Default: 5000)", 2);
                this.append(sb, "Wait in ms before each retry of the JBoss JMX MBean connection.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "The id of the server configuration found in Maven settings.xml. This configuration will determine the username/password to use when authenticating with the JBoss server. If no value is specified, a default username and password will be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverName (Default: default)", 2);
                this.append(sb, "The name of the configuration profile to use when starting the server. This might be something like 'all', 'default', or 'minimal'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "startOptions", 2);
                this.append(sb, "The set of space separated options to pass to the JBoss 'run' command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout (Default: 20000)", 2);
                this.append(sb, "Time in ms to start the application server (once JMX MBean connection has been reached).", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "stop".equals(this.goal)) {
            this.append(sb, "jboss:stop", 0);
            this.append(sb, "Stops JBoss. By default the plugin will return immediately after calling 'shutdown' command. The @see #stopWait parameter can be used to force the plugin to wait for a specified time before returning control.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "jbossHome", 2);
                this.append(sb, "The location of JBoss Home. This is a required configuration parameter (unless JBOSS_HOME is set).", 3);
                this.append(sb, "", 0);
                this.append(sb, "options", 2);
                this.append(sb, "Deprecated. use stopOptions instead", 3);
                this.append(sb, "", 0);
                this.append(sb, "The set of options to pass to the JBoss 'run' command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "The id of the server configuration found in Maven settings.xml. This configuration will determine the username/password to use when authenticating with the JBoss server. If no value is specified, a default username and password will be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverName (Default: default)", 2);
                this.append(sb, "The name of the configuration profile to use when starting the server. This might be something like 'all', 'default', or 'minimal'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopOptions (Default: -S)", 2);
                this.append(sb, "The set of options to pass to the JBoss 'run' command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopWait", 2);
                this.append(sb, "Wait in ms for server to shutdown before the plugin returns.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "undeploy".equals(this.goal)) {
            this.append(sb, "jboss:undeploy", 0);
            this.append(sb, "Undeploys a directory or file from JBoss via JMX.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "fileNames", 2);
                this.append(sb, "The name of the file or directory to deploy or undeploy.", 3);
                this.append(sb, "", 0);
                this.append(sb, "hostName (Default: localhost)", 2);
                this.append(sb, "The host JBoss is running on.", 3);
                this.append(sb, "", 0);
                this.append(sb, "port (Default: 8080)", 2);
                this.append(sb, "The port JBoss is running on.", 3);
                this.append(sb, "", 0);
                this.append(sb, "server", 2);
                this.append(sb, "Deprecated. Use serverId instead", 3);
                this.append(sb, "", 0);
                this.append(sb, "The id of the server configuration found in Maven settings.xml. This configuration will determine the username/password to use when authenticating with the JBoss server. If no value is specified, a default username and password will be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "The id of the server configuration found in Maven settings.xml. This configuration will determine the username/password to use when authenticating with the JBoss server. If no value is specified, a default username and password will be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip the mojo execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "undeployUrlPath", 2);
                this.append(sb, "The undeployment path relative to the base server URL.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "wait-app-start".equals(this.goal)) {
            this.append(sb, "jboss:wait-app-start", 0);
            this.append(sb, "Waits until an app is started.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "earName", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "hostName (Default: localhost)", 2);
                this.append(sb, "The host JBoss is running on.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jbossHome", 2);
                this.append(sb, "The location of JBoss Home. This is a required configuration parameter (unless JBOSS_HOME is set).", 3);
                this.append(sb, "", 0);
                this.append(sb, "namingPort (Default: 1099)", 2);
                this.append(sb, "The port for the naming service.", 3);
                this.append(sb, "", 0);
                this.append(sb, "options", 2);
                this.append(sb, "Deprecated. use startOptions instead", 3);
                this.append(sb, "", 0);
                this.append(sb, "The set of options to pass to the JBoss 'run' command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "retry (Default: 4)", 2);
                this.append(sb, "Maximum number of retries to get JBoss JMX MBean connection.", 3);
                this.append(sb, "", 0);
                this.append(sb, "retryWait (Default: 5000)", 2);
                this.append(sb, "Wait in ms before each retry of the JBoss JMX MBean connection.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId", 2);
                this.append(sb, "The id of the server configuration found in Maven settings.xml. This configuration will determine the username/password to use when authenticating with the JBoss server. If no value is specified, a default username and password will be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverName (Default: default)", 2);
                this.append(sb, "The name of the configuration profile to use when starting the server. This might be something like 'all', 'default', or 'minimal'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "startOptions", 2);
                this.append(sb, "The set of space separated options to pass to the JBoss 'run' command.", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout (Default: 20000)", 2);
                this.append(sb, "Time in ms to start the application server (once JMX MBean connection has been reached).", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

