/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jboss;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.jboss.AbstractJBossMojo;

public class HardDeployMojo
extends AbstractJBossMojo {
    protected String fileName;

    public void execute() throws MojoExecutionException {
        this.checkConfig();
        try {
            File src = new File(this.fileName);
            File dst = new File(this.jbossHome + "/server/" + this.serverName + "/deploy/" + src.getName());
            this.getLog().info((CharSequence)("Copying " + src.getAbsolutePath() + " to " + dst.getAbsolutePath()));
            this.copy(src, dst);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Mojo error occurred: " + e.getMessage(), e);
        }
    }

    private void copy(File srcDir, File dstDir) throws IOException {
        if (srcDir.isDirectory()) {
            if (!dstDir.exists()) {
                dstDir.mkdir();
            }
            String[] children = srcDir.list();
            for (int i = 0; i < children.length; ++i) {
                this.copy(new File(srcDir, children[i]), new File(dstDir, children[i]));
            }
        } else {
            this.copyFile(srcDir, dstDir);
        }
    }

    private void copyFile(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }
}

