/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.emma;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Nodes;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.emma.AbstractEmmaMojo;
import org.codehaus.mojo.emma.CheckConfiguration;
import org.codehaus.mojo.emma.CoverageResult;
import org.codehaus.mojo.emma.EmmaUtils;
import org.codehaus.mojo.emma.task.ReportTask;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.SelectorUtils;
import org.codehaus.plexus.util.StringUtils;

public class EmmaCheckMojo
extends AbstractEmmaMojo {
    private static final Map TAG_2_TYPE = new HashMap();
    protected File coverageFile;
    protected CheckConfiguration check;
    protected File metadataFile;
    protected File[] dataFiles;
    protected File outputDirectory;

    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        Document doc;
        if (this.dataFiles == null) {
            this.dataFiles = new File[]{new File(this.project.getBasedir(), "coverage.ec")};
        }
        this.dataFiles = EmmaUtils.fixDataFileLocations(this.project, this.dataFiles);
        if (this.coverageFile == null || !this.coverageFile.exists()) {
            if (this.dataFiles != null && this.dataFiles.length > 0) {
                this.coverageFile = this.generateReport();
            } else {
                this.getLog().info((CharSequence)"Not checking EMMA coverage results, as no results were found");
                return;
            }
        }
        if (this.check == null) {
            this.getLog().info((CharSequence)"Not checking EMMA coverage results, as no configuration was set");
            return;
        }
        this.getLog().info((CharSequence)"Checking EMMA coverage results");
        FileInputStream input = null;
        try {
            input = new FileInputStream(this.coverageFile);
            Builder builder = new Builder();
            doc = builder.build((InputStream)input);
        }
        catch (Exception e) {
            try {
                throw new MojoExecutionException("Failed to read EMMA coverage results from file: " + this.coverageFile.getPath(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close(input);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)input);
        CoverageResult allResults = null;
        ArrayList<CoverageResult> results = new ArrayList<CoverageResult>(3);
        try {
            Nodes allNodes = doc.query("/report/data/all");
            if (allNodes.size() > 0) {
                allResults = this.toCoverageResult((Element)allNodes.get(0));
            }
            String[] expressions = new String[]{"/report/data/all/package", "/report/data/all/package/srcfile/class", "/report/data/all/package/srcfile/class/method"};
            for (int i = 0; i < expressions.length; ++i) {
                Nodes nodes = doc.query(expressions[i]);
                int nodesLen = nodes.size();
                for (int j = 0; j < nodesLen; ++j) {
                    CoverageResult r = this.toCoverageResult((Element)nodes.get(j));
                    if (r == null) continue;
                    results.add(r);
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to parse EMMA coverage results from file: " + this.coverageFile.getName(), e);
        }
        if (this.getLog().isDebugEnabled()) {
            if (allResults == null && results.isEmpty()) {
                this.getLog().debug((CharSequence)"No coverage results!");
            } else {
                this.getLog().debug((CharSequence)"Coverage results:");
                if (allResults != null) {
                    this.getLog().debug((CharSequence)(" o " + allResults));
                }
                Collections.sort(results, new CoverageResultComparator());
                Iterator i = results.iterator();
                while (i.hasNext()) {
                    CoverageResult r = (CoverageResult)i.next();
                    this.getLog().debug((CharSequence)(" o " + r));
                }
            }
        }
        this.checkResults(allResults, results);
    }

    private void checkResults(CoverageResult allResults, List results) throws MojoFailureException {
        if (allResults != null) {
            if (allResults.getBlockRate() != -1 && allResults.getBlockRate() < this.check.getBlockRate()) {
                this.getLog().warn((CharSequence)("Insufficient code coverage for blocks: " + allResults.getBlockRate() + "% < " + this.check.getBlockRate() + "%"));
                this.fail();
                return;
            }
            if (allResults.getClassRate() != -1 && allResults.getClassRate() < this.check.getClassRate()) {
                this.getLog().warn((CharSequence)("Insufficient code coverage for classes: " + allResults.getClassRate() + "% < " + this.check.getClassRate() + "%"));
                this.fail();
                return;
            }
            if (allResults.getMethodRate() != -1 && allResults.getMethodRate() < this.check.getMethodRate()) {
                this.getLog().warn((CharSequence)("Insufficient code coverage for methods: " + allResults.getMethodRate() + "% < " + this.check.getMethodRate() + "%"));
                this.fail();
                return;
            }
            if (allResults.getLineRate() != -1 && allResults.getLineRate() < this.check.getLineRate()) {
                this.getLog().warn((CharSequence)("Insufficient code coverage for lines: " + allResults.getLineRate() + "% < " + this.check.getLineRate() + "%"));
                this.fail();
                return;
            }
        }
        for (int i = 0; i < this.check.getRegexes().length; ++i) {
            CheckConfiguration.Regex regex = this.check.getRegexes()[i];
            Iterator j = results.iterator();
            while (j.hasNext()) {
                CoverageResult result = (CoverageResult)j.next();
                if (!SelectorUtils.match((String)regex.getPattern(), (String)result.getName())) continue;
                if (result.getBlockRate() != -1 && result.getBlockRate() < regex.getBlockRate()) {
                    this.getLog().warn((CharSequence)("Insufficient code coverage for blocks in " + regex.getPattern() + ": " + result.getBlockRate() + "% < " + regex.getBlockRate() + "%"));
                    this.fail();
                    return;
                }
                if (result.getClassRate() != -1 && result.getClassRate() < regex.getClassRate()) {
                    this.getLog().warn((CharSequence)("Insufficient code coverage for classes in " + regex.getPattern() + ": " + result.getClassRate() + "% < " + regex.getClassRate() + "%"));
                    this.fail();
                    return;
                }
                if (result.getMethodRate() != -1 && result.getMethodRate() < regex.getMethodRate()) {
                    this.getLog().warn((CharSequence)("Insufficient code coverage for methods in " + regex.getPattern() + ": " + result.getMethodRate() + "% < " + regex.getMethodRate() + "%"));
                    this.fail();
                    return;
                }
                if (result.getLineRate() == -1 || result.getLineRate() >= regex.getLineRate()) continue;
                this.getLog().warn((CharSequence)("Insufficient code coverage for lines in " + regex.getPattern() + ": " + result.getLineRate() + "% < " + regex.getLineRate() + "%"));
                this.fail();
                return;
            }
        }
        this.getLog().info((CharSequence)"EMMA coverage results are valid");
    }

    private void fail() throws MojoFailureException {
        String failMsg = "Failed to validate EMMA coverage results: see report for more information";
        if (this.check.isHaltOnFailure()) {
            throw new MojoFailureException("Failed to validate EMMA coverage results: see report for more information");
        }
        this.getLog().warn((CharSequence)"Failed to validate EMMA coverage results: see report for more information");
    }

    private CoverageResult toCoverageResult(Element elem) {
        CoverageResult result;
        CoverageResult.Type type = (CoverageResult.Type)TAG_2_TYPE.get(elem.getLocalName());
        if (type == null) {
            return null;
        }
        if (CoverageResult.Type.ALL.equals(type)) {
            result = new CoverageResult();
        } else {
            String name = CoverageResult.Type.CLASS.equals(type) ? this.fullClassName(elem) : (CoverageResult.Type.METHOD.equals(type) ? this.fullMethodName(elem) : elem.getAttributeValue("name"));
            result = new CoverageResult(type, name);
        }
        Nodes coverageNodes = elem.query("coverage");
        int len = coverageNodes.size();
        for (int i = 0; i < len; ++i) {
            int coverageValue;
            int percentIndex;
            String coverageValueStr;
            Element coverageElem = (Element)coverageNodes.get(i);
            String coverageType = coverageElem.getAttributeValue("type");
            if (StringUtils.isEmpty((String)coverageType) || StringUtils.isEmpty((String)(coverageValueStr = coverageElem.getAttributeValue("value"))) || (percentIndex = coverageValueStr.indexOf(37)) == -1) continue;
            try {
                coverageValue = Integer.parseInt(coverageValueStr.substring(0, percentIndex).trim());
            }
            catch (NumberFormatException e) {
                this.getLog().debug((CharSequence)("Failed to parse coverage value: " + coverageValueStr), (Throwable)e);
                continue;
            }
            if (coverageType.startsWith("class")) {
                result.setClassRate(coverageValue);
                continue;
            }
            if (coverageType.startsWith("method")) {
                result.setMethodRate(coverageValue);
                continue;
            }
            if (coverageType.startsWith("block")) {
                result.setBlockRate(coverageValue);
                continue;
            }
            if (!coverageType.startsWith("line")) continue;
            result.setLineRate(coverageValue);
        }
        return result;
    }

    private String fullClassName(Element elem) {
        Element packageElem = (Element)elem.getParent().getParent();
        String packageName = packageElem.getAttributeValue("name");
        String className = elem.getAttributeValue("name");
        return packageName.length() != 0 ? packageName + "." + className : className;
    }

    private String fullMethodName(Element elem) {
        Element classElem = (Element)elem.getParent();
        String name = elem.getAttributeValue("name");
        int i = name.indexOf(" (");
        String methodName = i != -1 ? name.substring(0, i) : "static";
        return this.fullClassName(classElem) + "." + methodName;
    }

    private File generateReport() throws MojoExecutionException {
        ReportTask task = new ReportTask();
        task.setVerbose(this.verbose);
        task.setMetadataFile(this.metadataFile);
        task.setDataFiles(this.dataFiles);
        task.setOutputDirectory(this.outputDirectory);
        task.setGenerateOnlyXml(true);
        try {
            task.execute();
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        return new File(this.outputDirectory, "coverage.xml");
    }

    static {
        TAG_2_TYPE.put("all", CoverageResult.Type.ALL);
        TAG_2_TYPE.put("package", CoverageResult.Type.PACKAGE);
        TAG_2_TYPE.put("class", CoverageResult.Type.CLASS);
        TAG_2_TYPE.put("method", CoverageResult.Type.METHOD);
    }

    private static class CoverageResultComparator
    implements Comparator {
        private CoverageResultComparator() {
        }

        public int compare(Object o1, Object o2) {
            CoverageResult r1 = (CoverageResult)o1;
            CoverageResult r2 = (CoverageResult)o2;
            return r1.getName().compareTo(r2.getName());
        }
    }
}

