/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dita;

import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;

public abstract class AbstractProjectMojo
extends AbstractMojo {
    protected boolean skip;
    protected MavenProject project;
    protected MavenProjectHelper projectHelper;
    private ArchiverManager archiverManager;

    protected void executeCommandline(Commandline cl) throws MojoExecutionException {
        int ok;
        try {
            DefaultConsumer stdout;
            DefaultConsumer stderr = stdout = new DefaultConsumer();
            this.getLog().debug((CharSequence)cl.toString());
            ok = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
        }
        catch (CommandLineException ecx) {
            throw new MojoExecutionException("Error executing command line", (Exception)((Object)ecx));
        }
        if (ok != 0) {
            throw new MojoExecutionException("Error executing command line. Exit code:" + ok);
        }
    }

    protected void archiveAndAttachTheOutput(File outputDirectory, String classifier, String type) throws MojoExecutionException {
        String archiveOutputFileName = this.project.getArtifactId();
        if (!StringUtils.isBlank((String)classifier)) {
            archiveOutputFileName = archiveOutputFileName + "-" + classifier;
        }
        archiveOutputFileName = archiveOutputFileName + "." + type;
        File archiveOutputFile = new File(this.project.getBuild().getDirectory(), archiveOutputFileName);
        if (!this.isAttachYet(archiveOutputFile)) {
            try {
                Archiver archiver = this.archiverManager.getArchiver(archiveOutputFile);
                archiver.addDirectory(outputDirectory);
                archiver.setDestFile(archiveOutputFile);
                archiver.createArchive();
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
            this.attachArtifact(classifier, type, archiveOutputFile);
        }
    }

    protected void attachArtifact(String classifier, String type, File file) {
        if (StringUtils.isBlank((String)classifier)) {
            this.projectHelper.attachArtifact(this.project, type, file);
        } else {
            this.projectHelper.attachArtifact(this.project, type, classifier, file);
        }
    }

    protected boolean isAttachYet(File attachFile) throws MojoExecutionException {
        List attachedArtifacts = this.project.getAttachedArtifacts();
        for (Artifact artifact : attachedArtifacts) {
            if (!attachFile.equals(artifact.getFile())) continue;
            return true;
        }
        return false;
    }
}

