/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin.chart.time;

import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import org.codehaus.mojo.dashboard.report.plugin.chart.AbstractChartStrategy;
import org.codehaus.mojo.dashboard.report.plugin.utils.TimePeriod;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardXYItemLabelGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Minute;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.Week;

public abstract class AbstractTimeChartStrategy
extends AbstractChartStrategy {
    public static String xAxisLabel = "Date";
    public static String yAxisLabel = "Values";
    protected TimeSeriesCollection defaultdataset = new TimeSeriesCollection();
    protected ResourceBundle bundle;
    protected List mResults;
    protected TimePeriod timePeriod;
    protected Class periodClass;
    private Date startDate;
    private Date endDate;

    public AbstractTimeChartStrategy(ResourceBundle bundle, String title, List results, String timeUnit, Date startDate, Date endDate) {
        this.setTitle(title);
        this.bundle = bundle;
        this.mResults = results;
        this.startDate = startDate;
        this.endDate = endDate;
        this.retreivePeriodClass(timeUnit);
    }

    public Dataset getDataset() {
        this.fillDataset();
        if (this.defaultdataset.getSeriesCount() > 0) {
            this.setDatasetEmpty(false);
        }
        return this.defaultdataset;
    }

    public String getXAxisLabel() {
        return xAxisLabel;
    }

    public String getYAxisLabel() {
        return yAxisLabel;
    }

    private void retreivePeriodClass(String timeUnit) {
        this.timePeriod = TimePeriod.getPeriod(timeUnit);
        this.periodClass = null;
        this.periodClass = this.timePeriod.equals(TimePeriod.MINUTE) ? Minute.class : (this.timePeriod.equals(TimePeriod.HOUR) ? Hour.class : (this.timePeriod.equals(TimePeriod.DAY) ? Day.class : (this.timePeriod.equals(TimePeriod.WEEK) ? Week.class : (this.timePeriod.equals(TimePeriod.MONTH) ? Month.class : Day.class))));
    }

    protected RegularTimePeriod getChartDate(Date keyDate) {
        Object chartDate = null;
        chartDate = this.timePeriod.equals(TimePeriod.MINUTE) ? new Minute(keyDate) : (this.timePeriod.equals(TimePeriod.HOUR) ? new Hour(keyDate) : (this.timePeriod.equals(TimePeriod.DAY) ? new Day(keyDate) : (this.timePeriod.equals(TimePeriod.WEEK) ? new Week(keyDate) : (this.timePeriod.equals(TimePeriod.MONTH) ? new Month(keyDate) : new Hour(keyDate)))));
        return chartDate;
    }

    public TimePeriod getTimePeriod() {
        return this.timePeriod;
    }

    public NumberAxis getRangeAxis() {
        NumberAxis valueaxis = new NumberAxis();
        valueaxis.setLowerMargin(0.0);
        valueaxis.setUpperMargin(0.25);
        valueaxis.setLabel(this.getYAxisLabel());
        return valueaxis;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public XYItemLabelGenerator getLabelGenerator() {
        return new StandardXYItemLabelGenerator();
    }
}

