/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin.chart;

import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import org.codehaus.mojo.dashboard.report.plugin.chart.IChartRenderer;
import org.codehaus.mojo.dashboard.report.plugin.chart.IChartStrategy;
import org.codehaus.mojo.dashboard.report.plugin.utils.ChartUtils;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

public abstract class AbstractChartRenderer
implements IChartRenderer {
    protected JFreeChart report = null;
    private int width = 800;
    private int height = 400;
    protected IChartStrategy datasetStrategy;

    protected AbstractChartRenderer() {
    }

    public AbstractChartRenderer(IChartStrategy strategy) {
        this.datasetStrategy = strategy;
        this.createChart();
    }

    public AbstractChartRenderer(IChartStrategy strategy, int width, int height) {
        this(strategy);
        this.width = width;
        this.height = height;
    }

    public abstract void createChart();

    public JFreeChart getChart() {
        return this.report;
    }

    public boolean isEmpty() {
        return this.datasetStrategy.isDatasetEmpty();
    }

    public String getFileExtension() {
        return "png";
    }

    public String getMimeType() {
        return "image/png";
    }

    public void saveToFile(String filename) throws IOException {
        this.report.setBackgroundPaint((Paint)this.getBackgroundColor());
        File imageFile = new File(filename);
        imageFile.getParentFile().mkdirs();
        ChartUtilities.saveChartAsPNG((File)new File(filename), (JFreeChart)this.report, (int)this.width, (int)this.height);
    }

    public Color getBackgroundColor() {
        return (Color)ChartUtils.BLUE_STEEL2_LIGHT;
    }

    public BufferedImage createBufferedImage(int imageWidth, int imageHeight) {
        return this.report.createBufferedImage(imageWidth, imageHeight);
    }

    public void setHeight(int _height) {
        this.height = _height;
    }

    public void setWidth(int _width) {
        this.width = _width;
    }
}

