/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin.beans;

import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.mojo.dashboard.report.plugin.beans.AbstractReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.IDashBoardReportBean;

public class FindBugsReportBean
extends AbstractReportBean {
    private int nbClasses;
    private int nbBugs;
    private int nbErrors;
    private int nbMissingClasses;
    private Map categories = new Hashtable();
    private Map priorities = new Hashtable();

    public FindBugsReportBean() {
    }

    public FindBugsReportBean(Date dateGeneration) {
        super(dateGeneration);
    }

    public int getNbClasses() {
        return this.nbClasses;
    }

    public void setNbClasses(int nbClasses) {
        this.nbClasses = nbClasses;
    }

    public int getNbErrors() {
        return this.nbErrors;
    }

    public void setNbErrors(int nbErrors) {
        this.nbErrors = nbErrors;
    }

    public int getNbBugs() {
        return this.nbBugs;
    }

    public void setNbBugs(int nbBugs) {
        this.nbBugs = nbBugs;
    }

    public int getNbMissingClasses() {
        return this.nbMissingClasses;
    }

    public void setNbMissingClasses(int nbMissingClasses) {
        this.nbMissingClasses = nbMissingClasses;
    }

    public Map getCategories() {
        return this.categories;
    }

    public void setCategories(Map categories) {
        this.categories = categories;
    }

    public Map getPriorities() {
        return this.priorities;
    }

    public void setPriorities(Map priorities) {
        this.priorities = priorities;
    }

    public void addCategory(String category) {
        if (this.categories.isEmpty()) {
            this.categories.put(category, new Integer(1));
        } else if (this.categories.containsKey(category)) {
            Integer oldValue = (Integer)this.categories.get(category);
            this.categories.put(category, new Integer(oldValue + 1));
        } else {
            this.categories.put(category, new Integer(1));
        }
    }

    public void addAllCategories(Map categories) {
        if (this.categories.isEmpty()) {
            this.categories.putAll(categories);
        } else {
            Iterator iter = categories.keySet().iterator();
            while (iter.hasNext()) {
                String category = (String)iter.next();
                Integer newValuetoAdd = (Integer)categories.get(category);
                if (this.categories.containsKey(category)) {
                    Integer oldValue = (Integer)this.categories.get(category);
                    this.categories.put(category, new Integer(oldValue + newValuetoAdd));
                    continue;
                }
                this.categories.put(category, newValuetoAdd);
            }
        }
    }

    public void addPriority(String priority) {
        if (this.priorities.isEmpty()) {
            this.priorities.put(priority, new Integer(1));
        } else if (this.priorities.containsKey(priority)) {
            Integer oldValue = (Integer)this.priorities.get(priority);
            this.priorities.put(priority, new Integer(oldValue + 1));
        } else {
            this.priorities.put(priority, new Integer(1));
        }
    }

    public void addAllPriorities(Map priorities) {
        if (this.priorities.isEmpty()) {
            this.priorities.putAll(priorities);
        } else {
            Iterator iter = priorities.keySet().iterator();
            while (iter.hasNext()) {
                String priority = (String)iter.next();
                Integer newValuetoAdd = (Integer)priorities.get(priority);
                if (this.priorities.containsKey(priority)) {
                    Integer oldValue = (Integer)this.priorities.get(priority);
                    this.priorities.put(priority, new Integer(oldValue + newValuetoAdd));
                    continue;
                }
                this.priorities.put(priority, newValuetoAdd);
            }
        }
    }

    public void merge(IDashBoardReportBean dashboardReport) {
        if (dashboardReport != null && dashboardReport instanceof FindBugsReportBean) {
            this.nbClasses += ((FindBugsReportBean)dashboardReport).getNbClasses();
            this.nbBugs += ((FindBugsReportBean)dashboardReport).getNbBugs();
            this.nbErrors += ((FindBugsReportBean)dashboardReport).getNbErrors();
            this.nbMissingClasses += ((FindBugsReportBean)dashboardReport).getNbMissingClasses();
            this.addAllCategories(((FindBugsReportBean)dashboardReport).getCategories());
            this.addAllPriorities(((FindBugsReportBean)dashboardReport).getPriorities());
        }
    }

    protected Object clone() {
        FindBugsReportBean clone = new FindBugsReportBean(this.getDateGeneration());
        clone.setNbClasses(this.nbClasses);
        clone.setNbBugs(this.nbBugs);
        clone.setNbMissingClasses(this.nbMissingClasses);
        clone.setNbErrors(this.nbErrors);
        clone.addAllCategories(this.getCategories());
        clone.addAllPriorities(this.getPriorities());
        return clone;
    }
}

