/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.vsslib;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import org.apache.maven.changelog.AbstractChangeLogGenerator;
import org.apache.maven.changelog.ChangeLog;
import org.apache.maven.changelog.ChangeLogParser;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.vsslib.VssConnection;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.types.Commandline;

public class VssChangeLogGenerator
extends AbstractChangeLogGenerator {
    private static final Log LOG = ChangeLog.getLog();

    protected Commandline getScmLogCommand() {
        VssConnection vssConnection = new VssConnection(this.getConnection());
        Commandline command = new Commandline();
        command.setExecutable("ss");
        command.createArgument().setValue("History");
        command.createArgument().setValue("$" + vssConnection.getVssProject());
        if (vssConnection.getVssUserInf() != null) {
            command.createArgument().setValue("-Y" + vssConnection.getVssUserInf());
        }
        command.createArgument().setValue("-R");
        command.createArgument().setValue("-I-");
        if (this.dateRange != null) {
            command.createArgument().setValue("-Vd" + this.dateRange);
        }
        return command;
    }

    protected String getScmDateArgument(Date before, Date to) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy", Locale.ENGLISH);
        String result = sdf.format(to) + "~" + sdf.format(before);
        return result;
    }

    protected String getScmTagArgument(String tagStart, String tagEnd) {
        throw new UnsupportedOperationException("Cannot presently use tags for SCM operations on VSS");
    }

    public void setDateRange(String numDaysString) {
        int days = Integer.parseInt(numDaysString);
        Date before = new Date(System.currentTimeMillis() - (long)days * 24L * 60L * 60L * 1000L);
        Date to = new Date(System.currentTimeMillis() + 86400000L);
    }

    public Collection getEntries(ChangeLogParser parser) throws IOException {
        if (parser == null) {
            throw new NullPointerException("parser cannot be null");
        }
        if (this.base == null) {
            throw new NullPointerException("basedir must be set");
        }
        if (!this.base.exists()) {
            throw new FileNotFoundException("Cannot find base dir " + this.base.getAbsolutePath());
        }
        this.clParser = parser;
        try {
            VssConnection vssConnection = new VssConnection(this.getConnection());
            Execute exe = new Execute((ExecuteStreamHandler)this);
            String[] env = exe.getEnvironment();
            if (env == null) {
                env = new String[]{};
            }
            String[] newEnv = new String[env.length + 1];
            for (int i = 0; i < env.length; ++i) {
                newEnv[i] = env[i];
            }
            newEnv[env.length] = "SSDIR=" + vssConnection.getVssDir();
            exe.setEnvironment(newEnv);
            exe.setCommandline(this.getScmLogCommand().getCommandline());
            exe.setWorkingDirectory(this.base);
            AbstractChangeLogGenerator.logExecute(exe, this.base);
            exe.execute();
            String errors = this.errorReader.toString().trim();
            if (errors.length() > 0) {
                LOG.error((CharSequence)errors);
            }
        }
        catch (IOException ioe) {
            this.handleParserException(ioe);
        }
        return this.entries;
    }
}

