/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.java.metadata;

import java.util.Map;
import org.codehaus.modello.metadata.AbstractMetadataPlugin;
import org.codehaus.modello.metadata.AssociationMetadata;
import org.codehaus.modello.metadata.ClassMetadata;
import org.codehaus.modello.metadata.FieldMetadata;
import org.codehaus.modello.metadata.MetadataPlugin;
import org.codehaus.modello.metadata.ModelMetadata;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugin.java.metadata.JavaAssociationMetadata;
import org.codehaus.modello.plugin.java.metadata.JavaClassMetadata;
import org.codehaus.modello.plugin.java.metadata.JavaFieldMetadata;
import org.codehaus.modello.plugin.java.metadata.JavaModelMetadata;

public class JavaMetadataPlugin
extends AbstractMetadataPlugin
implements MetadataPlugin {
    public static final String JAVA_ABSTRACT = "java.abstract";
    public static final String JAVA_ADDER = "java.adder";
    public static final String JAVA_BIDI = "java.bidi";
    public static final String JAVA_ENABLED = "java.enabled";
    public static final String JAVA_GETTER = "java.getter";
    public static final String JAVA_INIT = "java.init";
    public static final String JAVA_SETTER = "java.setter";
    public static final String JAVA_USE_INTERFACE = "java.useInterface";

    public ModelMetadata getModelMetadata(Model model, Map data) {
        return new JavaModelMetadata();
    }

    public ClassMetadata getClassMetadata(ModelClass clazz, Map data) {
        JavaClassMetadata metadata = new JavaClassMetadata();
        metadata.setEnabled(this.getBoolean(data, JAVA_ENABLED, true));
        metadata.setAbstract(this.getBoolean(data, JAVA_ABSTRACT, false));
        return metadata;
    }

    public FieldMetadata getFieldMetadata(ModelField field, Map data) {
        JavaFieldMetadata metadata = new JavaFieldMetadata();
        metadata.setGetter(this.getBoolean(data, JAVA_GETTER, true));
        String fieldType = field.getType();
        metadata.setBooleanGetter(fieldType != null && fieldType.endsWith("oolean"));
        metadata.setSetter(this.getBoolean(data, JAVA_SETTER, true));
        return metadata;
    }

    public AssociationMetadata getAssociationMetadata(ModelAssociation association, Map data) {
        JavaAssociationMetadata metadata = new JavaAssociationMetadata();
        metadata.setAdder(this.getBoolean(data, JAVA_ADDER, true));
        metadata.setBidi(this.getBoolean(data, JAVA_BIDI, true));
        metadata.setInterfaceName(this.getString(data, JAVA_USE_INTERFACE));
        metadata.setInitializationMode(this.getString(data, JAVA_INIT));
        return metadata;
    }
}

