/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.compiler;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.codehaus.groovy.eclipse.compiler.InternalCompiler;
import org.codehaus.plexus.compiler.AbstractCompiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.compiler.CompilerResult;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyEclipseCompiler
extends AbstractCompiler {
    private static final String PROB_SEPARATOR = "----------\n";
    private static final String JAVA_AGENT_CLASS_PARAM_NAME = "-javaAgentClass";
    private String javaAgentClass = "";
    boolean verbose;

    public GroovyEclipseCompiler() {
        super(CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE, "", ".class", null);
    }

    public CompilerResult performCompile(CompilerConfiguration configuration) throws CompilerException {
        this.checkForGroovyEclipseBatch();
        ArrayList<CompilerMessage> messages = new ArrayList<CompilerMessage>();
        boolean result = this.internalCompile(configuration, messages);
        return new CompilerResult(result, messages);
    }

    private void checkForGroovyEclipseBatch() throws CompilerException {
        try {
            Class.forName("org.eclipse.jdt.core.compiler.CompilationProgress");
        }
        catch (Exception e) {
            throw new CompilerException("Could not find groovy-eclipse-batch artifact. Must add this artifact as an explicit dependency the pom.");
        }
    }

    private boolean internalCompile(CompilerConfiguration config, List<CompilerMessage> messages) throws CompilerException {
        boolean success;
        String[] args = this.createCommandLine(config);
        if (args.length == 0) {
            this.getLogger().info("Nothing to compile - all classes are up to date");
            return true;
        }
        if (config.isFork()) {
            String executable = config.getExecutable();
            if (StringUtils.isEmpty((String)executable)) {
                try {
                    executable = this.getJavaExecutable();
                }
                catch (IOException e) {
                    this.getLogger().warn("Unable to autodetect 'java' path, using 'java' from the environment.");
                    executable = "java";
                }
            }
            String groovyEclipseLocation = this.getGroovyEclipseBatchLocation();
            success = this.compileOutOfProcess(config, executable, groovyEclipseLocation, args, messages);
        } else {
            StringWriter out = new StringWriter();
            InternalCompiler.Result result = InternalCompiler.doCompile(args, out, this.getLogger(), this.verbose);
            success = result.success;
            try {
                messages.addAll(this.parseMessages(success ? 0 : 1, out.getBuffer().toString(), config.isShowWarnings()));
            }
            catch (IOException e) {
                messages = new ArrayList<CompilerMessage>(1);
            }
            if (!success) {
                messages.add(this.formatResult(success, result.globalErrorsCount, result.globalWarningsCount));
            }
        }
        return success;
    }

    private File[] recalculateStaleFiles(CompilerConfiguration config) throws CompilerException {
        config.setSourceFiles(null);
        long staleMillis = 0L;
        Set<String> includes = config.getIncludes();
        if (includes == null || includes.isEmpty()) {
            includes = Collections.singleton("**/*");
        }
        StaleSourceScanner scanner = new StaleSourceScanner(staleMillis, includes, config.getExcludes());
        Set<File> staleSources = this.computeStaleSources(config, (SourceInclusionScanner)scanner);
        config.setSourceFiles(staleSources);
        File[] sourceFiles = staleSources.toArray(new File[0]);
        return sourceFiles;
    }

    private boolean startsWithHyphen(Object key) {
        return null != key && String.class.isInstance(key) && ((String)key).startsWith("-");
    }

    private CompilerMessage formatResult(boolean result, int globalErrorsCount, int globalWarningsCount) {
        if (result) {
            return new CompilerMessage("Success!", CompilerMessage.Kind.NOTE);
        }
        CompilerMessage.Kind kind = globalErrorsCount > 0 ? CompilerMessage.Kind.ERROR : (globalWarningsCount > 0 ? CompilerMessage.Kind.WARNING : CompilerMessage.Kind.NOTE);
        String error = globalErrorsCount == 1 ? "error" : "errors";
        String warning = globalWarningsCount == 1 ? "warning" : "warnings";
        return new CompilerMessage("Found " + globalErrorsCount + " " + error + " and " + globalWarningsCount + " " + warning + ".", kind);
    }

    private Map<String, String> composeSourceFiles(File[] sourceFiles) {
        DeduplicatingHashMap<String, String> sources = new DeduplicatingHashMap<String, String>(this.getLogger(), sourceFiles.length);
        for (int i = 0; i < sourceFiles.length; ++i) {
            sources.put(sourceFiles[i].getPath(), null);
        }
        return sources;
    }

    public String[] createCommandLine(CompilerConfiguration config) throws CompilerException {
        String source;
        File[] sourceFiles;
        File srcTestGroovy;
        File srcMainGroovy;
        File destinationDir = new File(config.getOutputLocation());
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        File workingDirectory = config.getWorkingDirectory();
        if (destinationDir.getName().equals("classes") && (srcMainGroovy = new File(workingDirectory, "src/main/groovy")).exists() && !config.getSourceLocations().contains(srcMainGroovy.getAbsolutePath())) {
            config.addSourceLocation(srcMainGroovy.getAbsolutePath());
        }
        if (destinationDir.getName().equals("test-classes") && (srcTestGroovy = new File(workingDirectory, "src/test/groovy")).exists() && !config.getSourceLocations().contains(srcTestGroovy.getAbsolutePath())) {
            config.addSourceLocation(srcTestGroovy.getAbsolutePath());
        }
        if ((sourceFiles = this.recalculateStaleFiles(config)).length == 0) {
            return new String[0];
        }
        this.getLogger().info("Using Groovy-Eclipse compiler to compile both Java and Groovy files");
        this.getLogger().debug("Compiling " + sourceFiles.length + " " + "source file" + (sourceFiles.length == 1 ? "" : "s") + " to " + destinationDir.getAbsolutePath());
        DeduplicatingHashMap<String, String> args = new DeduplicatingHashMap<String, String>(this.getLogger());
        String cp = AbstractCompiler.getPathString((List)config.getClasspathEntries());
        this.verbose = config.isVerbose();
        if (this.verbose) {
            this.getLogger().info("Classpath: " + cp);
        }
        if (cp.length() > 0) {
            args.put("-cp", cp);
        }
        if (config.getOutputLocation() != null && config.getOutputLocation().length() > 0) {
            args.put("-d", config.getOutputLocation());
        }
        if (config.isDebug()) {
            if (config.getDebugLevel() != null && config.getDebugLevel().trim().length() > 0) {
                args.put("-g:" + config.getDebugLevel(), null);
            } else {
                args.put("-g", null);
            }
        }
        if ("none".equals(config.getProc())) {
            args.put("-proc:none", null);
        } else if ("only".equals(config.getProc())) {
            args.put("-proc:only", null);
        }
        if (config.getGeneratedSourcesDirectory() != null) {
            args.put("-s", config.getGeneratedSourcesDirectory().getAbsolutePath());
        }
        if ((source = config.getSourceVersion()) != null && source.length() > 0) {
            args.put("-source", source);
        } else {
            args.put("-source", "1.5");
        }
        String target = config.getTargetVersion();
        if (target != null && target.length() > 0) {
            args.put("-target", target);
        } else {
            args.put("-target", "1.5");
        }
        if (config.isShowDeprecation()) {
            args.put("-deprecation", null);
        }
        if (!config.isShowWarnings()) {
            args.put("-nowarn", null);
        }
        if (config.getAnnotationProcessors() != null) {
            StringBuilder procArg = new StringBuilder();
            for (String proc : config.getAnnotationProcessors()) {
                if (proc == null || proc.trim().length() <= 0) continue;
                procArg.append(proc);
                procArg.append(",");
            }
            if (procArg.length() > 0) {
                procArg.replace(procArg.length() - 1, procArg.length(), "");
                args.put("-processor ", "\"" + procArg.toString() + "\"");
            }
        }
        if (this.verbose) {
            args.put("-verbose", null);
        }
        if (config.getSourceEncoding() != null) {
            args.put("-encoding", config.getSourceEncoding());
        }
        for (Map.Entry entry : config.getCustomCompilerArgumentsAsMap().entrySet()) {
            String key = (String)entry.getKey();
            if (this.startsWithHyphen(key)) {
                if (JAVA_AGENT_CLASS_PARAM_NAME.equals(key)) {
                    this.setJavaAgentClass((String)entry.getValue());
                    continue;
                }
                args.put(key, (String)entry.getValue());
                continue;
            }
            if (key == null || key.equals("org.osgi.framework.system.packages")) continue;
            args.put("-" + key, (String)entry.getValue());
        }
        args.putAll(this.composeSourceFiles(sourceFiles));
        Object[] argsList = this.flattenArgumentsMap(args);
        if (this.verbose) {
            this.getLogger().info("All args: " + Arrays.toString(argsList));
        }
        return argsList;
    }

    private Set<File> computeStaleSources(CompilerConfiguration compilerConfiguration, SourceInclusionScanner scanner) throws CompilerException {
        SuffixMapping mappingGroovy = new SuffixMapping(".groovy", ".class");
        SuffixMapping mappingJava = new SuffixMapping(".java", ".class");
        scanner.addSourceMapping((SourceMapping)mappingGroovy);
        scanner.addSourceMapping((SourceMapping)mappingJava);
        File outputDirectory = new File(compilerConfiguration.getOutputLocation());
        HashSet<File> staleSources = new HashSet<File>();
        for (String sourceRoot : compilerConfiguration.getSourceLocations()) {
            File rootFile;
            if (this.verbose) {
                this.getLogger().info("Looking for sources in source root: " + sourceRoot);
            }
            if (!(rootFile = new File(sourceRoot)).isDirectory()) continue;
            try {
                staleSources.addAll(scanner.getIncludedSources(rootFile, outputDirectory));
            }
            catch (InclusionScanException e) {
                throw new CompilerException("Error scanning source root: '" + sourceRoot + "' " + "for stale files to recompile.", (Throwable)e);
            }
        }
        return staleSources;
    }

    private boolean compileOutOfProcess(CompilerConfiguration config, String executable, String groovyEclipseLocation, String[] args, List<CompilerMessage> messages) throws CompilerException {
        int returnCode;
        CommandLineUtils.StringStreamConsumer err;
        CommandLineUtils.StringStreamConsumer out;
        Commandline cli;
        block15: {
            cli = new Commandline();
            cli.setWorkingDirectory(config.getWorkingDirectory().getAbsolutePath());
            cli.setExecutable(executable);
            try {
                if (!StringUtils.isEmpty((String)this.javaAgentClass)) {
                    cli.addArguments(new String[]{"-javaagent:" + this.getAdditionnalJavaAgentLocation()});
                } else {
                    this.getLogger().info("no javaAgentClass seems to be set");
                }
                cli.addArguments(new String[]{"-jar", groovyEclipseLocation});
                File argumentsFile = this.createFileWithArguments(args, config.getOutputLocation());
                cli.addArguments(new String[]{"@" + argumentsFile.getCanonicalPath().replace(File.separatorChar, '/')});
                if (!StringUtils.isEmpty((String)config.getMaxmem())) {
                    cli.addArguments(new String[]{"-J-Xmx" + config.getMaxmem()});
                }
                if (!StringUtils.isEmpty((String)config.getMeminitial())) {
                    cli.addArguments(new String[]{"-J-Xms" + config.getMeminitial()});
                }
            }
            catch (IOException e) {
                throw new CompilerException("Error creating file with javac arguments", (Throwable)e);
            }
            out = new CommandLineUtils.StringStreamConsumer();
            err = new CommandLineUtils.StringStreamConsumer();
            if (this.getLogger() != null && this.getLogger().isDebugEnabled()) {
                File commandLineFile = new File(config.getOutputLocation(), "greclipse." + (Os.isFamily((String)"windows") ? "bat" : "sh"));
                try {
                    FileUtils.fileWrite((String)commandLineFile.getAbsolutePath(), (String)cli.toString().replaceAll("'", ""));
                    if (!Os.isFamily((String)"windows")) {
                        Runtime.getRuntime().exec(new String[]{"chmod", "a+x", commandLineFile.getAbsolutePath()});
                    }
                }
                catch (IOException e) {
                    if (this.getLogger() == null || !this.getLogger().isWarnEnabled()) break block15;
                    this.getLogger().warn("Unable to write '" + commandLineFile.getName() + "' debug script file", (Throwable)e);
                }
            }
        }
        try {
            this.getLogger().info("Compiling in a forked process using " + groovyEclipseLocation);
            returnCode = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)out, (StreamConsumer)err);
            messages.addAll(this.parseMessages(returnCode, out.getOutput(), config.isShowWarnings()));
        }
        catch (CommandLineException e) {
            throw new CompilerException("Error while executing the external compiler.", (Throwable)e);
        }
        catch (IOException e) {
            throw new CompilerException("Error while executing the external compiler.", (Throwable)e);
        }
        if (returnCode != 0 && messages.isEmpty()) {
            if (err.getOutput().length() == 0) {
                throw new CompilerException("Unknown error trying to execute the external compiler: " + EOL + cli.toString());
            }
            messages.add(new CompilerMessage("Failure executing groovy-eclipse compiler:" + EOL + err.getOutput(), CompilerMessage.Kind.ERROR));
        }
        return returnCode == 0;
    }

    private List<CompilerMessage> parseMessages(int exitCode, String input, boolean showWarnings) throws IOException {
        String[] msgs;
        ArrayList<CompilerMessage> parsedMessages = new ArrayList<CompilerMessage>();
        for (String msg : msgs = input.split(PROB_SEPARATOR)) {
            if (msg.length() <= 1) continue;
            CompilerMessage message = this.parseMessage(msg, showWarnings, false);
            if (message != null) {
                if (!showWarnings && message.getKind() != CompilerMessage.Kind.ERROR) continue;
                parsedMessages.add(message);
                continue;
            }
            String[] extraMsgs = msg.split("\n");
            StringBuilder sb = new StringBuilder();
            for (String extraMsg : extraMsgs) {
                if (extraMsg.indexOf(". WARNING") > 0 || extraMsg.indexOf(". ERROR") > 0) {
                    this.handleCurrentMessage(showWarnings, parsedMessages, sb);
                    sb = new StringBuilder("\n").append(extraMsg).append("\n");
                    continue;
                }
                if (PROB_SEPARATOR.equals(extraMsg)) continue;
                sb.append(extraMsg).append("\n");
            }
            this.handleCurrentMessage(showWarnings, parsedMessages, sb);
        }
        return parsedMessages;
    }

    private void handleCurrentMessage(boolean showWarnings, List<CompilerMessage> parsedMessages, StringBuilder sb) {
        if (sb.length() > 0) {
            CompilerMessage message = this.parseMessage(sb.toString(), showWarnings, true);
            if (showWarnings || message.getKind() == CompilerMessage.Kind.ERROR) {
                parsedMessages.add(message);
            }
        }
    }

    private CompilerMessage parseMessage(String msgText, boolean showWarning, boolean force) {
        String rest;
        CompilerMessage.Kind kind;
        int dotIndex = msgText.indexOf(46);
        boolean isNormal = false;
        if (dotIndex > 0) {
            if (msgText.substring(dotIndex, dotIndex + ". WARNING".length()).equals(". WARNING")) {
                kind = CompilerMessage.Kind.WARNING;
                isNormal = true;
                dotIndex += ". WARNING in ".length();
            } else if (msgText.substring(dotIndex, dotIndex + ". ERROR".length()).equals(". ERROR")) {
                kind = CompilerMessage.Kind.ERROR;
                isNormal = true;
                dotIndex += ". ERROR in ".length();
            } else {
                kind = CompilerMessage.Kind.NOTE;
            }
        } else {
            kind = CompilerMessage.Kind.NOTE;
        }
        int firstNewline = msgText.indexOf(10);
        String firstLine = firstNewline > 0 ? msgText.substring(0, firstNewline) : msgText;
        String string = rest = firstNewline > 0 ? msgText.substring(firstNewline + 1) : "";
        if (isNormal) {
            try {
                int parenIndex = firstLine.indexOf(" (");
                String file = firstLine.substring(dotIndex, parenIndex);
                int line = Integer.parseInt(firstLine.substring(parenIndex + " (at line ".length(), firstLine.indexOf(41)));
                int lastLineIndex = rest.lastIndexOf("\n\t");
                int startColumn = rest.indexOf(94, lastLineIndex) - 1 - lastLineIndex;
                int endColumn = rest.lastIndexOf(94) - 1 - lastLineIndex;
                return new CompilerMessage(file, kind, line, startColumn, line, endColumn, msgText);
            }
            catch (RuntimeException e) {
                if (force) {
                    return new CompilerMessage(msgText, kind);
                }
                return null;
            }
        }
        if (force) {
            return new CompilerMessage(msgText, kind);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createFileWithArguments(String[] args, String outputDirectory) throws IOException {
        PrintWriter writer = null;
        try {
            File tempFile;
            if (this.getLogger() != null && this.getLogger().isDebugEnabled()) {
                tempFile = File.createTempFile(GroovyEclipseCompiler.class.getName(), "arguments", new File(outputDirectory));
            } else {
                tempFile = File.createTempFile(GroovyEclipseCompiler.class.getName(), "arguments");
                tempFile.deleteOnExit();
            }
            writer = new PrintWriter(new FileWriter(tempFile));
            for (int i = 0; i < args.length; ++i) {
                String argValue = args[i].replace(File.separatorChar, '/');
                writer.write("\"" + argValue + "\"");
                writer.println();
            }
            writer.flush();
            File file = tempFile;
            return file;
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private String getAdditionnalJavaAgentLocation() throws CompilerException {
        return this.getClassLocation(this.getJavaAgentClass());
    }

    private String getGroovyEclipseBatchLocation() throws CompilerException {
        return this.getClassLocation("org.eclipse.jdt.internal.compiler.batch.Main");
    }

    private String getClassLocation(String className) throws CompilerException {
        Class<?> cls;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new CompilerException("Cannot find the requested className <" + className + "> in classpath");
        }
        ProtectionDomain pDomain = cls.getProtectionDomain();
        CodeSource cSource = pDomain.getCodeSource();
        if (cSource != null) {
            File file;
            URL loc = cSource.getLocation();
            try {
                file = new File(URLDecoder.decode(loc.getPath(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                this.getLogger().warn("Unsupported Encoding for URL: " + loc, (Throwable)e);
                file = new File(loc.getPath());
            }
            this.getLogger().info("Found location <" + file.getPath() + "> for className <" + className + ">");
            return file.getPath();
        }
        throw new CompilerException("Cannot find the location of the requested className <" + className + "> in classpath");
    }

    private String getJavaExecutable() throws IOException {
        String javaCommand = "java" + (Os.isFamily((String)"windows") ? ".exe" : "");
        String javaHome = System.getProperty("java.home");
        File javaExe = Os.isName((String)"AIX") ? new File(javaHome + File.separator + ".." + File.separator + "sh", javaCommand) : (Os.isName((String)"Mac OS X") ? new File(javaHome + File.separator + "bin", javaCommand) : new File(javaHome + File.separator + ".." + File.separator + "bin", javaCommand));
        if (!javaExe.isFile()) {
            Properties env = CommandLineUtils.getSystemEnvVars();
            javaHome = env.getProperty("JAVA_HOME");
            if (StringUtils.isEmpty((String)javaHome)) {
                throw new IOException("The environment variable JAVA_HOME is not correctly set.");
            }
            if (!new File(javaHome).isDirectory()) {
                throw new IOException("The environment variable JAVA_HOME=" + javaHome + " doesn't exist or is not a valid directory.");
            }
            javaExe = new File(env.getProperty("JAVA_HOME") + File.separator + "bin", javaCommand);
        }
        if (!javaExe.isFile()) {
            throw new IOException("The javadoc executable '" + javaExe + "' doesn't exist or is not a file. Verify the JAVA_HOME environment variable.");
        }
        return javaExe.getAbsolutePath();
    }

    private String[] flattenArgumentsMap(Map<String, String> args) {
        ArrayList<String> argsList = new ArrayList<String>(args.size() * 2);
        for (Map.Entry<String, String> entry : args.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key == null || key.length() <= 0) continue;
            argsList.add(key);
            if (value == null || value.length() <= 0) continue;
            argsList.add(value);
        }
        return argsList.toArray(new String[0]);
    }

    public String getJavaAgentClass() {
        return this.javaAgentClass;
    }

    public void setJavaAgentClass(String className) {
        this.javaAgentClass = className;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeduplicatingHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = -589299605523895999L;
        private Logger logger;

        public DeduplicatingHashMap(Logger logger, int initialCapacity) {
            super(initialCapacity);
            this.logger = logger;
        }

        public DeduplicatingHashMap(Logger logger) {
            this.logger = logger;
        }

        @Override
        public V put(K key, V value) {
            if (this.containsKey(key) && this.logger.isDebugEnabled()) {
                this.logger.debug("Replacing compiler argument \"" + key + "\" old value: " + this.get(key) + " with: " + value);
            }
            return super.put(key, value);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            for (Map.Entry<K, V> entry : m.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }
}

