/*
 * Decompiled with CFR 0.152.
 */
package jsr166y.forkjoin;

import jsr166y.forkjoin.ForkJoinTask;
import jsr166y.forkjoin.TaskBarrier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CyclicAction
extends ForkJoinTask<Void> {
    final TaskBarrier barrier;
    int phase = -1;

    public CyclicAction(TaskBarrier barrier) {
        this.barrier = barrier;
        barrier.register();
    }

    protected abstract void compute();

    public final TaskBarrier getBarrier() {
        return this.barrier;
    }

    public final int getCycle() {
        return this.barrier.getCycle();
    }

    @Override
    public final Void rawResult() {
        return null;
    }

    @Override
    public final Throwable exec() {
        TaskBarrier b = this.barrier;
        if (this.isDone()) {
            b.arriveAndDeregister();
            return this.getException();
        }
        this.phase = this.phase < 0 ? b.getCycle() : b.awaitCycleAdvance(this.phase);
        if (this.phase < 0) {
            return this.setDone();
        }
        try {
            this.compute();
        }
        catch (Throwable rex) {
            b.arriveAndDeregister();
            return this.setDoneExceptionally(rex);
        }
        b.arrive();
        this.fork();
        return null;
    }

    @Override
    public final Void forkJoin() {
        this.exec();
        return (Void)this.join();
    }

    public final void finish() {
        this.setDone();
    }

    @Override
    public final void finish(Void result) {
        this.setDone();
    }

    @Override
    public final void finishExceptionally(Throwable ex) {
        this.setDoneExceptionally(ex);
    }
}

