/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.model;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.chorem.pollen.votecounting.model.GroupOfVoter;
import org.chorem.pollen.votecounting.model.VoteCountingResult;

public class GroupVoteCountingResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected GroupOfVoter voter;
    protected Map<String, GroupOfVoter> groups;

    public static GroupVoteCountingResult newResult(GroupOfVoter voter, Set<GroupOfVoter> groups) {
        GroupVoteCountingResult result = new GroupVoteCountingResult();
        result.setVoter(voter);
        groups.remove(voter);
        result.setGroups(groups);
        return result;
    }

    public VoteCountingResult getMainResult() {
        return this.voter.getResult();
    }

    public Set<String> getGroupIds() {
        return Sets.newHashSet(this.groups.keySet());
    }

    public VoteCountingResult getGroupResult(String groupId) {
        GroupOfVoter groupOfVoter = this.groups.get(groupId);
        VoteCountingResult result = groupOfVoter.getResult();
        return result;
    }

    public void setVoter(GroupOfVoter voter) {
        this.voter = voter;
    }

    public void setGroups(Set<GroupOfVoter> groups) {
        this.groups = Maps.uniqueIndex(groups, (Function)new Function<GroupOfVoter, String>(){

            public String apply(GroupOfVoter input) {
                return input.getVoterId();
            }
        });
    }
}

