/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.poll.admin;

import com.google.common.base.Preconditions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.ui.actions.PollUriAware;
import org.chorem.pollen.ui.actions.PollenActionSupport;
import org.chorem.pollen.ui.actions.PollenUserSecurityAware;

public class DeletePoll
extends PollenActionSupport
implements PollenUserSecurityAware,
PollUriAware {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DeletePoll.class);
    protected String redirectUrl;

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public String execute() throws Exception {
        Preconditions.checkState((boolean)this.getUserSecurityContext().isCreator());
        Poll poll = this.getUserSecurityContext().getPoll();
        String title = this.getUserSecurityContext().getPoll().getTitle();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Will delete poll %s", title));
        }
        this.getPollService().deletePoll(poll.getPollId());
        this.addFlashMessage(this._("pollen.information.poll.deleted", new Object[]{title}));
        return "success";
    }
}

