/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: Register.java 3579 2012-07-31 16:21:30Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.5/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/user/Register.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.user;

import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.services.exceptions.UserEmailAlreadyUsedException;
import org.chorem.pollen.services.exceptions.UserLoginAlreadyUsedException;
import org.chorem.pollen.ui.actions.PollenActionSupportForEdition;
import org.nuiton.util.StringUtil;

/**
 * Register a new user.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class Register extends PollenActionSupportForEdition {

    private static final long serialVersionUID = 1L;

    protected UserAccount pollenUserAccount;

    protected String password2;

    public UserAccount getPollenUserAccount() {
        if (pollenUserAccount == null) {
            pollenUserAccount = getUserService().getNewUser();
        }
        return pollenUserAccount;
    }

    public String getPassword2() {
        return password2;
    }

    public void setPassword2(String password2) {
        this.password2 = password2;
    }

    @Override
    public void validate() {

        if (StringUtils.isBlank(pollenUserAccount.getLogin())) {
            addFieldError("pollenUserAccount.login", _("pollen.error.login.required"));
        }

        if (StringUtils.isBlank(pollenUserAccount.getPassword())) {
            addFieldError("pollenUserAccount.password", _("pollen.error.password.required"));
        }

        if (StringUtils.isBlank(getPassword2())) {
            addFieldError("password2", _("pollen.error.password2.required"));
        }

        if (ObjectUtils.notEqual(getPassword2(), pollenUserAccount.getPassword())) {
            addFieldError("password2", _("pollen.error.passwords.not.equals"));
        }

        if (StringUtils.isBlank(pollenUserAccount.getEmail())) {
            addFieldError("pollenUserAccount.email", _("pollen.error.email.required"));
        } else if (!StringUtil.isEmail(pollenUserAccount.getEmail())) {
            addFieldError("pollenUserAccount.email", _("pollen.error.email.invalid"));
        }
    }

    @Override
    public String execute() throws Exception {

        String result = INPUT;
        try {
            UserAccount createdUser = getUserService().createUser(pollenUserAccount, false);

            getPollenSession().setUserAccount(createdUser);
            addFlashMessage(_("pollen.information.your.are.loggued"));
            result = SUCCESS;
        } catch (UserLoginAlreadyUsedException e) {
            addFieldError("pollenUserAccount.login", _("pollen.error.user.login.already.used"));
        } catch (UserEmailAlreadyUsedException e) {
            addFieldError("pollenUserAccount.email", _("pollen.error.user.email.already.used"));
        }

        // if error go back to input

        // reset password
        pollenUserAccount.setPassword(null);
        password2 = null;

        return result;
    }
}
