/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: AbstractJSONPaginedAction.java 3702 2012-09-23 13:48:42Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.5/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/json/AbstractJSONPaginedAction.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.json;

import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.json.JSONException;
import org.apache.struts2.json.JSONUtil;
import org.chorem.pollen.ui.actions.PollenActionSupport;
import org.nuiton.topia.persistence.pager.TopiaPagerBean;

import java.util.Map;

/**
 * Abstract JSON action with pagination support.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public abstract class AbstractJSONPaginedAction extends PollenActionSupport {

    private static final long serialVersionUID = 1L;

    public abstract Map<String, Object>[] getData();

    public final Integer getRows() {
        return pager.getPageSize();
    }

    public final Integer getPage() {
        return pager.getPageIndex();
    }

    public final Long getTotal() {
        return pager.getPagesNumber();
    }

    public final Long getRecords() {
        return pager.getRecords();
    }

    protected TopiaPagerBean pager = new TopiaPagerBean();

    protected String filters;

    public void setRows(Integer rows) {
        pager.setPageSize(rows);
    }

    public void setPage(Integer page) {
        pager.setPageIndex(page);
    }

    public void setSord(String sord) {
        pager.setSortAscendant("asc".equals(sord));
    }

    public String getSidx() {
        return pager.getSortColumn();
    }

    public void setSidx(String sidx) {
        pager.setSortColumn(sidx);
    }

    public String getFilters() {
        return filters;
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }

    protected Object getFilterObject() throws JSONException {
        Object filterObject = null;
        if (StringUtils.isNotEmpty(filters)) {
            filterObject = JSONUtil.deserialize(filters);
        }
        return filterObject;
    }
}
