/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.json;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.chorem.pollen.PollenUserSecurityContext;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.entities.PollenBinderHelper;
import org.chorem.pollen.services.impl.PollService;
import org.chorem.pollen.services.impl.SecurityService;
import org.chorem.pollen.ui.actions.json.AbstractJSONPaginedAction;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.Binder;

public class GetCreatedPolls
extends AbstractJSONPaginedAction {
    private static final long serialVersionUID = 1L;
    protected transient Map<String, Object>[] data;

    public Map<String, Object>[] getData() {
        return this.data;
    }

    public String execute() throws Exception {
        PollService pollService = this.getPollService();
        List pollList = pollService.getCreatedPolls(this.pager, this.getPollenUserAccount());
        this.data = new Map[pollList.size()];
        TopiaEntityBinder binder = PollenBinderHelper.getSimpleTopiaBinder(Poll.class);
        int index = 0;
        for (Poll poll : pollList) {
            Map map = pollService.pollToMap(poll, (Binder)binder);
            map.put("voteId", poll.getPollId());
            map.put("resultId", poll.getPollId());
            map.put("adminId", poll.getAdminId());
            map.put("functions", this.getPollFunctions(poll));
            this.data[index++] = map;
        }
        return "success";
    }

    protected Set<String> getPollFunctions(Poll poll) {
        HashSet result = Sets.newHashSet();
        PollenUserSecurityContext securityContext = PollenUserSecurityContext.newContext((UserAccount)this.getPollenUserAccount(), (String)poll.getPollId(), null, (Poll)poll);
        SecurityService securityService = this.getSecurityService();
        securityContext.loadUserRoles(securityService);
        boolean canAccessResult = securityService.isCanAccessResult(securityContext);
        if (canAccessResult) {
            result.add("result");
        } else {
            result.add("noresult");
        }
        boolean canVote = securityService.isCanVote(securityContext);
        if (canVote) {
            result.add("vote");
        } else {
            boolean canAccessVote = securityService.isCanAccessVote(securityContext);
            if (canAccessVote) {
                result.add("accessVote");
            } else {
                result.add("novote");
            }
        }
        result.add("summary");
        return result;
    }
}

