/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: SelectPersonListToVotingList.java 3611 2012-08-13 14:11:15Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.2/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/poll/form/SelectPersonListToVotingList.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.poll.form;

import com.google.common.collect.Maps;
import org.chorem.pollen.PollenFunctions;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.ui.actions.PollenActionSupport;

import java.util.List;
import java.util.Map;

/**
 * Select a person list to add into an existing voting list.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class SelectPersonListToVotingList extends PollenActionSupport {

    private static final long serialVersionUID = 1L;

    protected String votingListType;

    protected int votingListNumber;

    protected String containerId;

    protected Map<String, PersonList> personList;

    public Map<String, PersonList> getPersonList() {
        return personList;
    }

    public int getVotingListNumber() {
        return votingListNumber;
    }

    public void setVotingListNumber(int votingListNumber) {
        this.votingListNumber = votingListNumber;
    }

    public String getVotingListType() {
        return votingListType;
    }

    public void setVotingListType(String votingListType) {
        this.votingListType = votingListType;
    }

    public String getContainerId() {
        return containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    @Override
    public String execute() throws Exception {

        UserAccount userAccount = getPollenUserAccount();
        List<PersonList> personLists =
                getFavoriteService().getFavoriteLists(userAccount);

        personList = Maps.uniqueIndex(personLists, PollenFunctions.ENTITY_BY_ID);

        return SUCCESS;
    }
}
