/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions;

import com.google.common.collect.Lists;
import com.opensymphony.xwork2.ActionContext;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.struts2.ServletActionContext;
import org.chorem.pollen.PollenConfiguration;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.common.VoteCountingType;
import org.chorem.pollen.services.DefaultPollenServiceContext;
import org.chorem.pollen.services.PollenService;
import org.chorem.pollen.services.PollenServiceContext;
import org.chorem.pollen.services.PollenServiceFactory;
import org.chorem.pollen.ui.PollenApplicationContext;
import org.chorem.pollen.ui.PollenSession;
import org.chorem.pollen.ui.actions.PageSkin;
import org.chorem.pollen.ui.actions.PollenActionSupport;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.framework.TopiaTransactionAware;
import org.nuiton.web.filter.TopiaTransactionFilter;
import org.nuiton.web.struts2.BaseAction;

/*
 * Exception performing whole class analysis ignored.
 */
public class PollenActionSupport
extends BaseAction
implements TopiaTransactionAware {
    private static final long serialVersionUID = 1L;
    private transient PollenSession pollenSession;
    protected transient PollenServiceFactory serviceFactory;
    protected transient PollenServiceContext serviceContext;
    protected transient TopiaContext transaction;
    public static final List<String> SAFE_LANGUAGES = Lists.newArrayList((Object[])new String[]{"en", "fr"});

    public static PollenApplicationContext getPollenApplicationContext() {
        PollenApplicationContext applicationContext = PollenApplicationContext.get((ActionContext)PollenActionSupport.getActionContext());
        return applicationContext;
    }

    public PollenConfiguration getConfiguration() {
        return PollenActionSupport.getPollenApplicationContext().getConfiguration();
    }

    public PageSkin getSkin() {
        return PageSkin.INDEX;
    }

    public String getPageLogo() {
        return this.getSkin().getCssSuffix();
    }

    public String getJqueryTheme() {
        return this.getSkin().getTheme();
    }

    public PollenSession getPollenSession() {
        if (this.pollenSession == null) {
            this.pollenSession = PollenSession.get((ActionContext)PollenActionSupport.getActionContext());
        }
        return this.pollenSession;
    }

    public UserAccount getPollenUserAccount() {
        return this.getPollenSession().getUserAccount();
    }

    public boolean isUserLoggued() {
        UserAccount userAccount = this.getPollenUserAccount();
        return userAccount != null;
    }

    public boolean isUserAdmin() {
        UserAccount userAccount = this.getPollenUserAccount();
        return userAccount != null && userAccount.isAdministrator();
    }

    public static String getApplicationVersion() {
        return PollenActionSupport.getPollenApplicationContext().getConfiguration().getVersion().toString();
    }

    public URL getApplicationUrl() {
        URL url = this.getServiceContext().getApplicationURL();
        return url;
    }

    protected PollenServiceContext getServiceContext() {
        if (this.serviceContext == null) {
            this.serviceContext = DefaultPollenServiceContext.newContext((Locale)this.getLocale(), (TopiaContext)this.getTransaction(), (PollenConfiguration)this.getConfiguration(), (PollenServiceFactory)this.getServiceFactory());
        }
        return this.serviceContext;
    }

    public PollenServiceFactory getServiceFactory() {
        if (this.serviceFactory == null) {
            this.serviceFactory = new PollenServiceFactory();
        }
        return this.serviceFactory;
    }

    public <E extends PollenService> E newService(Class<E> serviceClass) {
        PollenService service = this.getServiceFactory().newService(serviceClass, this.getServiceContext());
        return (E)service;
    }

    public TopiaContext getTransaction() {
        if (this.transaction == null) {
            HttpServletRequest request = (HttpServletRequest)PollenActionSupport.getActionContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
            this.transaction = TopiaTransactionFilter.getTransaction((ServletRequest)request);
        }
        return this.transaction;
    }

    public void setTransaction(TopiaContext transaction) {
        this.transaction = transaction;
    }

    public String getSafeLanguage() {
        String language = this.getLocale().getLanguage();
        if (!SAFE_LANGUAGES.contains(language)) {
            language = (String)SAFE_LANGUAGES.get(0);
        }
        return language;
    }

    protected static ActionContext getActionContext() {
        return ActionContext.getContext();
    }

    public static Date getCurrentDateTime() {
        return new Date();
    }

    public String getVoteCountingTypeHelp(VoteCountingType voteCountingType) {
        String result;
        switch (1.$SwitchMap$org$chorem$pollen$common$VoteCountingType[voteCountingType.ordinal()]) {
            default: {
                result = this._("pollen.common.voteCountingTypeHelp.normal", new Object[0]);
                break;
            }
            case 2: {
                result = this._("pollen.common.voteCountingTypeHelp.percentage", new Object[0]);
                break;
            }
            case 3: {
                result = this._("pollen.common.voteCountingTypeHelp.condorcet", new Object[0]);
                break;
            }
            case 4: {
                result = this._("pollen.common.voteCountingTypeHelp.number", new Object[0]);
            }
        }
        return result;
    }

    public String getCurrentUrl() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String result = request.getRequestURL().toString();
        return result;
    }

    public void addFlashMessage(String message) {
        List messages = (List)this.getPollenSession().getDynamicData("messages");
        if (messages == null) {
            messages = Lists.newArrayList((Object[])new String[]{message});
            this.getPollenSession().putDynamicData("messages", (Object)messages);
        } else {
            messages.add(message);
        }
    }

    public void addFlashError(String message) {
        List messages = (List)this.getPollenSession().getDynamicData("errors");
        if (messages == null) {
            messages = Lists.newArrayList((Object[])new String[]{message});
            this.getPollenSession().putDynamicData("errors", (Object)messages);
        } else {
            messages.add(message);
        }
    }

    public Collection<String> getFlashMessages() {
        List<String> result = (List<String>)this.getPollenSession().getDynamicData("messages");
        if (result == null) {
            result = Collections.emptyList();
        } else {
            this.getPollenSession().removeDynamicData("messages");
        }
        return result;
    }

    public Collection<String> getFlashErrors() {
        List<String> result = (List<String>)this.getPollenSession().getDynamicData("errors");
        if (result == null) {
            result = Collections.emptyList();
        } else {
            this.getPollenSession().removeDynamicData("errors");
        }
        return result;
    }

    public boolean hasFlashMessages() {
        List result = (List)this.getPollenSession().getDynamicData("messages");
        return CollectionUtils.isNotEmpty((Collection)result);
    }

    public boolean hasFlashErrors() {
        List result = (List)this.getPollenSession().getDynamicData("errors");
        return CollectionUtils.isNotEmpty((Collection)result);
    }

    public void clearFlashMessages() {
        List result = (List)this.getPollenSession().getDynamicData("messages");
        if (result != null) {
            result.clear();
        }
    }

    public void clearFlashErrors() {
        List result = (List)this.getPollenSession().getDynamicData("errors");
        if (result != null) {
            result.clear();
        }
    }

    public boolean hasAnyErrors() {
        boolean result = super.hasErrors();
        return result || this.hasFlashErrors();
    }
}

