/*
 * #%L
 * Pollen :: UI (strust2)
 * 
 * $Id: GetPollComments.java 3380 2012-05-24 09:18:03Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3.1.1/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/json/GetPollComments.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.json;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import org.chorem.pollen.business.persistence.Comment;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.entities.PollenBinderHelper;
import org.chorem.pollen.services.impl.PollCommentService;
import org.nuiton.util.beans.Binder;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Get paginated list of poll comments.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class GetPollComments extends AbstractJSONPaginedAction {

    private static final long serialVersionUID = 1L;

    protected transient Map<String, Object>[] comments;

    protected String pollId;

    public void setPollId(String pollId) {
        this.pollId = pollId;
    }

    public Map<String, Object>[] getComments() {
        return comments;
    }

    @Override
    public Integer getRows() {
        return pager.getPageSize();
    }

    @Override
    public Integer getPage() {
        return pager.getPageIndex();
    }

    @Override
    public Integer getTotal() {
        return pager.getPagesNumber();
    }

    @Override
    public Integer getRecords() {
        return pager.getRecords();
    }

    @Override
    public String execute() throws Exception {

        Preconditions.checkNotNull(pollId);

        PollCommentService pollService = newService(PollCommentService.class);

        List<Comment> commentList = pollService.getComments(pager, pollId);

        UserAccount userAccount = getPollenUserAccount();

        comments = new Map[commentList.size()];
        Binder<Comment, Comment> binder =
                PollenBinderHelper.getSimpleTopiaBinder(Comment.class);
        int index = 0;
        for (Comment comment : commentList) {

            Map<String, Object> map = binder.obtainProperties(
                    comment,
                    Comment.PROPERTY_TEXT,
                    Comment.PROPERTY_POST_DATE,
                    Comment.PROPERTY_AUTHOR
            );
            map.put("id", comment.getTopiaId());
            Set<String> functions = getCommentFunctions(pollService,
                                                        comment,
                                                        userAccount);
            map.put("functions", functions);
            comments[index++] = map;
        }
        return SUCCESS;
    }

    private Set<String> getCommentFunctions(PollCommentService pollService,
                                            Comment comment,
                                            UserAccount userAccount) {
        Set<String> result = Sets.newHashSet();
        boolean canDelete = pollService.isCanDeleteComment(comment,
                                                           null,
                                                           userAccount);
        if (canDelete) {
            result.add("delete");
        }
        return result;
    }


}