/*
 * #%L
 * Pollen :: Services
 * $Id: DefaultPollenServiceContext.java 3708 2012-09-29 12:36:25Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5/pollen-services/src/main/java/org/chorem/pollen/services/DefaultPollenServiceContext.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.services;

import com.google.common.base.Preconditions;
import org.chorem.pollen.PollenConfiguration;
import org.chorem.pollen.votecounting.VoteCountingFactory;
import org.nuiton.topia.TopiaContext;

import java.net.URL;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;

/**
 * Instances of this class will be given to service factory.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class DefaultPollenServiceContext implements PollenServiceContext {

    protected TopiaContext transaction;

    protected PollenServiceFactory serviceFactory;

    protected PollenConfiguration configuration;

    protected Locale locale;

    protected VoteCountingFactory voteCountingFactory;

    public static PollenServiceContext newContext(
            PollenServiceContext serviceContext,
            TopiaContext transaction) {
        return newContext(serviceContext.getLocale(),
                          transaction,
                          serviceContext.getConfiguration(),
                          serviceContext.getServiceFactory(),
                          serviceContext.getVoteCountingFactory()

        );
    }

    public static PollenServiceContext newContext(
            Locale locale,
            TopiaContext transaction,
            PollenConfiguration configuration,
            PollenServiceFactory serviceFactory,
            VoteCountingFactory voteCountingFactory) {
        return new DefaultPollenServiceContext(locale,
                                               transaction,
                                               configuration,
                                               serviceFactory,
                                               voteCountingFactory);
    }

    protected DefaultPollenServiceContext(
            Locale locale,
            TopiaContext transaction,
            PollenConfiguration configuration,
            PollenServiceFactory serviceFactory,
            VoteCountingFactory voteCountingFactory) {
        this.locale = locale;
        this.transaction = transaction;
        this.configuration = configuration;
        this.serviceFactory = serviceFactory;
        this.voteCountingFactory = voteCountingFactory;
    }

    @Override
    public TopiaContext getTransaction() {
        Preconditions.checkNotNull(transaction);
        return transaction;
    }

    @Override
    public void setTransaction(TopiaContext transaction) {
        this.transaction = transaction;
    }

    @Override
    public Locale getLocale() {
        return locale;
    }

    @Override
    public URL getApplicationURL() {
        return getConfiguration().getApplicationUrl();
    }

    @Override
    public boolean isCanSendEmail() {
        return getApplicationURL() != null;
    }

    @Override
    public <E extends PollenService> E newService(Class<E> clazz) {
        return serviceFactory.newService(clazz, this);
    }

    @Override
    public PollenConfiguration getConfiguration() {
        return configuration;
    }

    @Override
    public PollenServiceFactory getServiceFactory() {
        return serviceFactory;
    }

    @Override
    public Date getCurrentTime() {
        return new Date();
    }

    @Override
    public VoteCountingFactory getVoteCountingFactory() {
        return voteCountingFactory;
    }

    @Override
    public String generateId() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }
}
