/*
 * #%L
 * Pollen :: Services
 * $Id: PollenMigrationCallbackV1_3_1.java 3423 2012-06-05 16:50:22Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4/pollen-services/src/main/java/org/chorem/pollen/entities/migration/PollenMigrationCallbackV1_3_1.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.entities.migration;

import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.framework.TopiaSQLQuery;
import org.nuiton.topia.migration.TopiaMigrationCallbackByClassNG;
import org.nuiton.util.Version;
import org.nuiton.util.VersionUtil;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/**
 * Migration for version {@code 1.3.1}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3.1
 */
public class PollenMigrationCallbackV1_3_1 extends TopiaMigrationCallbackByClassNG.MigrationCallBackForVersion {

    @Override
    public Version getVersion() {
        return VersionUtil.valueOf("1.3.1");
    }

    @Override
    protected void prepareMigrationScript(TopiaContextImplementor tx,
                                          List<String> queries,
                                          boolean showSql,
                                          boolean showProgression) throws TopiaException {

        // add indexed choices (says there is an order kept in db) : http://chorem.org/issues/154
        addIndexedChoices(tx, queries);
    }

    private void addIndexedChoices(TopiaContextImplementor tx,
                                   List<String> queries) throws TopiaException {

        queries.add("ALTER TABLE choice ADD COLUMN poll_idx INTEGER;");

        // get all polls


        TopiaSQLQuery<String> getAllPollsQuery = new TopiaSQLQuery<String>() {

            @Override
            protected PreparedStatement prepareQuery(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("select distinct(poll) from choice;");
                return ps;
            }

            @Override
            protected String prepareResult(ResultSet set) throws SQLException {
                return set.getString(1);
            }
        };
        List<String> pollIds = getAllPollsQuery.findMultipleResult(tx);

        String choiceUpdate = "UPDATE choice SET poll_idx = %s WHERE topiaid = '%s';";

        for (final String pollId : pollIds) {

            // get all choice ids for this poll
            List<String> choiceIds =
                    new GetChoiceIdsSQLQuery(pollId).findMultipleResult(tx);

            int index = 0;
            for (String choiceId : choiceIds) {
                queries.add(String.format(choiceUpdate, index++, choiceId));
            }

        }

        // now can add not null constraints
        // can not use this strong not null constraint, hibernate will at create time let a null value here :(
//        queries.add("ALTER TABLE choice ALTER COLUMN poll_idx SET NOT NULL;");
    }

    private static class GetChoiceIdsSQLQuery extends TopiaSQLQuery<String> {

        private final String pollId;

        public GetChoiceIdsSQLQuery(String pollId) {
            this.pollId = pollId;
        }

        @Override
        protected PreparedStatement prepareQuery(Connection connection) throws SQLException {
            PreparedStatement ps = connection.prepareStatement(
                    "SELECT topiaid FROM choice WHERE poll = ? ORDER BY topiacreatedate;");
            ps.setString(1, pollId);
            return ps;
        }

        @Override
        protected String prepareResult(ResultSet set) throws SQLException {
            return set.getString(1);
        }
    }
}
