/*
 * #%L
 * Pollen :: Services
 * $Id: UserPoll.java 3423 2012-06-05 16:50:22Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4/pollen-services/src/main/java/org/chorem/pollen/bean/UserPoll.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.bean;


import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class UserPoll implements Serializable {

    private static final long serialVersionUID = 7293352208965578801L;

    public static final String PROPERTY_POLL = "poll";

    public static final String PROPERTY_ACCOUNTS = "accounts";

    public static final String PROPERTY_CREATOR = "creator";

    protected Boolean creator;

    protected Poll poll;

    protected List<PollAccount> accounts;

    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public boolean isCreator() {
        // Lazy initialization of creator boolean
        if (creator == null) {
            for (PollAccount account : accounts) {
                if (account.equals(poll.getCreator())) {
                    creator = true;
                    break;
                }
            }
            if (creator == null) {
                creator = false;
            }
        }
        return creator;
    }

    public String getPollUid() {
        return poll.getPollId();
    }

    public List<PollAccount> getAccounts() {
        if (accounts == null) {
            accounts = new ArrayList<PollAccount>();
        }
        return accounts;
    }

    public boolean addAccount(PollAccount account) {
        boolean result = getAccounts().add(account);
        return result;
    }

    public Poll getPoll() {
        return poll;
    }

    public void setPoll(Poll poll) {
        Poll oldValue = getPoll();
        this.poll = poll;
        firePropertyChange(PROPERTY_POLL, oldValue, poll);
    }


    public void setAccounts(List<PollAccount> accounts) {
        List<PollAccount> oldValue = getAccounts();
        this.accounts = accounts;
        firePropertyChange(PROPERTY_ACCOUNTS, oldValue, accounts);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, Object newValue) {
        firePropertyChange(propertyName, null, newValue);
    }

} //UserPoll
