/*
 * #%L
 * Pollen :: Services
 * 
 * $Id: FavoriteListImport.java 3307 2012-04-24 10:45:44Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3/pollen-services/src/main/java/org/chorem/pollen/services/FavoriteListImport.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.services;

import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.services.exceptions.FavoriteListImportException;
import org.chorem.pollen.services.impl.FavoriteListImportCSV;
import org.chorem.pollen.services.impl.FavoriteListImportLDAP;

import java.util.List;

/**
 * Used to import a favorite List or a List of {@link PollAccount} from a given
 * source url (file, external service, ...)
 * 
 * Created: 16/04/12
 *
 * @author fdesbois <desbois@codelutin.com>
 * @since 1.3
 * @see FavoriteListImportLDAP
 * @see FavoriteListImportCSV
 */
public interface FavoriteListImport {

    /**
     * Execute the import from given {@code url}. This will returned the
     * successful list of {@link PollAccount} instanciated during import. No
     * database save is done here, only the extraction from an input url to
     * a list of entities to manage.
     * 
     * @param url Url of the file or service that contains data to import
     * @return the List of PollAccount imported
     * @throws FavoriteListImportException for any import error
     */
    public List<PollAccount> execute(String url)
            throws FavoriteListImportException;
}
