/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.persistence.entity;

import com.google.common.collect.Maps;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.persistence.AbstractPollenDao;
import org.chorem.pollen.persistence.AbstractPollenEntity;
import org.chorem.pollen.persistence.entity.ChoiceDao;
import org.chorem.pollen.persistence.entity.Comment;
import org.chorem.pollen.persistence.entity.CommentDao;
import org.chorem.pollen.persistence.entity.Poll;
import org.chorem.pollen.persistence.entity.PollEvent;
import org.chorem.pollen.persistence.entity.PollEventDao;
import org.chorem.pollen.persistence.entity.PollFeedDao;
import org.chorem.pollen.persistence.entity.PollenPrincipal;
import org.chorem.pollen.persistence.entity.PollenResource;
import org.chorem.pollen.persistence.entity.PollenUser;
import org.chorem.pollen.persistence.entity.Question;
import org.chorem.pollen.persistence.entity.QuestionDao;
import org.chorem.pollen.persistence.entity.Vote;
import org.chorem.pollen.persistence.entity.VoteDao;
import org.chorem.pollen.persistence.entity.VoterList;
import org.chorem.pollen.persistence.entity.VoterListDao;
import org.chorem.pollen.persistence.entity.VoterListMember;
import org.chorem.pollen.persistence.topia.query.AddCriteriaOrRunQueryStep;
import org.nuiton.util.pagination.PaginationOrder;
import org.nuiton.util.pagination.PaginationParameter;
import org.nuiton.util.pagination.PaginationResult;

public class PollDao
extends AbstractPollenDao<Poll> {
    @Override
    public Class<Poll> getEntityClass() {
        return Poll.class;
    }

    public void deleteFromParent(Poll entity) {
        if (!entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + String.valueOf(entity) + " is not persisted, you can't delete it");
        }
        List list = this.daoSupplier.getCommentDao().forPollEquals(entity).findAll();
        for (AbstractPollenEntity item : list) {
            if (!entity.equals(((Comment)item).getPoll())) continue;
            ((Comment)item).setPoll(null);
        }
        list = this.daoSupplier.getVoterListDao().forPollEquals(entity).findAll();
        for (AbstractPollenEntity item : list) {
            if (!entity.equals(((VoterList)item).getPoll())) continue;
            ((VoterList)item).setPoll(null);
        }
        list = this.daoSupplier.getQuestionDao().forPollEquals(entity).findAll();
        for (AbstractPollenEntity item : list) {
            if (!entity.equals(((Question)item).getPoll())) continue;
            ((Question)item).setPoll(null);
        }
        super.delete(entity);
    }

    public AddCriteriaOrRunQueryStep<Poll> forPictureEquals(PollenResource v) {
        return this.forEquals("picture", v);
    }

    public AddCriteriaOrRunQueryStep<Poll> forCreatorEquals(PollenPrincipal v) {
        return this.forEquals("creator", v);
    }

    public PaginationResult<Poll> findAll(PaginationParameter page, String search) {
        HashMap parameters = Maps.newHashMap();
        String hql = "SELECT poll FROM " + Poll.class.getName() + " as poll";
        if (StringUtils.isNotBlank((CharSequence)search)) {
            hql = hql + " WHERE " + this.getSearchClause("poll", parameters, "title", search);
        }
        return this.findPage(hql, parameters, page);
    }

    public PaginationResult<Poll> findAllUserPolls(PollenUser user, PaginationParameter page, String search, String filter) {
        String strFilter;
        HashMap parameters = Maps.newHashMap();
        parameters.put("user", user);
        Object hqlCondition = "";
        if (StringUtils.isNotBlank((CharSequence)filter) && !(strFilter = this.filterCondition(filter, parameters)).isEmpty()) {
            parameters.put("today", new Date());
            hqlCondition = (String)hqlCondition + strFilter;
        }
        return this.findAllUserPollsWithConditions(user, page, search, parameters, (String)hqlCondition);
    }

    public PaginationResult<Poll> findAllCreated(PollenUser user, PaginationParameter page, String search, String filter) {
        String strFilter;
        HashMap parameters = Maps.newHashMap();
        parameters.put("user", user);
        String hql = "SELECT poll FROM " + Poll.class.getName() + " as poll WHERE poll.creator.pollenUser = :user";
        if (StringUtils.isNotBlank((CharSequence)search)) {
            hql = hql + " AND " + this.getSearchClause("poll", parameters, "title", search);
        }
        if (StringUtils.isNotBlank((CharSequence)filter) && !(strFilter = this.filterCondition(filter, parameters)).isEmpty()) {
            parameters.put("today", new Date());
            hql = hql + " AND " + strFilter;
        }
        return this.findPage(hql, parameters, page);
    }

    public PaginationResult<Poll> findAllInvited(PollenUser user, PaginationParameter page, String search, String filter) {
        String strFilter;
        HashMap parameters = Maps.newHashMap();
        parameters.put("user", user);
        String hql = "FROM " + VoterListMember.class.getName() + " as mem INNER JOIN mem.voterList.poll as poll WHERE mem.member.pollenUser = :user";
        if (StringUtils.isNotBlank((CharSequence)search)) {
            hql = hql + " AND " + this.getSearchClause("poll", parameters, "title", search);
        }
        if (StringUtils.isNotBlank((CharSequence)filter) && !(strFilter = this.filterCondition(filter, parameters)).isEmpty()) {
            parameters.put("today", new Date());
            hql = hql + " AND " + strFilter;
        }
        PaginationOrder order = (PaginationOrder)page.getOrderClauses().getFirst();
        PaginationParameter page2 = PaginationParameter.of((int)page.getPageNumber(), (int)page.getPageSize(), (String)("poll." + order.getClause()), (boolean)order.isDesc());
        List polls = this.find("SELECT DISTINCT poll " + hql, parameters, page2);
        long count = this.count("SELECT COUNT(DISTINCT poll.topiaId) " + hql, parameters);
        return PaginationResult.of(polls, (long)count, (PaginationParameter)page);
    }

    public PaginationResult<Poll> findAllParticipated(PollenUser user, PaginationParameter page, String search, String filter) {
        String strFilter;
        HashMap parameters = Maps.newHashMap();
        parameters.put("user", user);
        String hql = "FROM " + Vote.class.getName() + " as vote  INNER JOIN vote.question as question INNER JOIN question.poll as poll WHERE vote.voter.pollenUser = :user";
        if (StringUtils.isNotBlank((CharSequence)search)) {
            hql = hql + " AND " + this.getSearchClause("poll", parameters, "title", search);
        }
        if (StringUtils.isNotBlank((CharSequence)filter) && !(strFilter = this.filterCondition(filter, parameters)).isEmpty()) {
            parameters.put("today", new Date());
            hql = hql + " AND " + strFilter;
        }
        PaginationOrder order = (PaginationOrder)page.getOrderClauses().getFirst();
        PaginationParameter page2 = PaginationParameter.of((int)page.getPageNumber(), (int)page.getPageSize(), (String)("poll." + order.getClause()), (boolean)order.isDesc());
        List polls = this.find("SELECT poll " + hql, parameters, page2);
        long count = this.count("SELECT COUNT(poll.topiaId) " + hql, parameters);
        return PaginationResult.of(polls, (long)count, (PaginationParameter)page);
    }

    private String filterCondition(String filter, Map<String, Object> parameters) {
        return switch (filter.toUpperCase()) {
            case "PAST" -> "poll.endDate IS NOT NULL  AND poll.endDate <= :today ";
            case "CURRENT" -> "(poll.beginDate IS NULL OR poll.beginDate <= :today)  AND ( poll.endDate IS NULL OR poll.endDate>= :today)";
            case "UPCOMING" -> "poll.beginDate IS NOT NULL  AND poll.beginDate >= :today ";
            default -> "";
        };
    }

    private PaginationResult<Poll> findAllUserPollsWithConditions(PollenUser user, PaginationParameter page, String search, Map<String, Object> parameters, String hqlCondition) {
        String hql = "FROM " + Poll.class.getName() + " as poll  WHERE (poll.creator.pollenUser = :user OR EXISTS (SELECT 1 FROM " + VoterListMember.class.getName() + " memb             WHERE memb.voterList.poll.topiaId = poll.topiaId             AND memb.member.pollenUser = :user ) OR EXISTS (SELECT 1 FROM " + Vote.class.getName() + " vote             WHERE vote.voter.pollenUser = :user              AND vote.question.poll.topiaId = poll.topiaId))";
        if (StringUtils.isNotBlank((CharSequence)hqlCondition)) {
            hql = hql + " AND " + hqlCondition;
        }
        if (StringUtils.isNotBlank((CharSequence)search)) {
            hql = hql + " AND " + this.getSearchClause("poll", parameters, "title", search);
        }
        PaginationOrder order = (PaginationOrder)page.getOrderClauses().getFirst();
        PaginationParameter page2 = PaginationParameter.of((int)page.getPageNumber(), (int)page.getPageSize(), (String)("poll." + order.getClause()), (boolean)order.isDesc());
        List polls = this.find("SELECT poll " + hql, parameters, page2);
        long count = this.count("SELECT COUNT(poll.topiaId) " + hql, parameters);
        return PaginationResult.of(polls, (long)count, (PaginationParameter)page);
    }

    @Override
    public void delete(Poll poll) {
        QuestionDao questionDao = this.daoSupplier.getQuestionDao();
        List questions = questionDao.forPollEquals(poll).findAll();
        for (Question question : questions) {
            AbstractPollenDao dao = this.daoSupplier.getChoiceDao();
            List choices = ((ChoiceDao)dao).forQuestionEquals(question).findAll();
            dao.deleteAll(choices);
            dao = this.daoSupplier.getVoteDao();
            List votes = ((VoteDao)dao).forQuestionEquals(question).findAll();
            dao.deleteAll(votes);
            dao = this.daoSupplier.getCommentDao();
            List comments = ((CommentDao)dao).forQuestionEquals(question).findAll();
            dao.deleteAll(comments);
            questionDao.delete(question);
        }
        AbstractPollenDao dao = this.daoSupplier.getCommentDao();
        List comments = ((CommentDao)dao).forPollEquals(poll).findAll();
        dao.deleteAll(comments);
        dao = this.daoSupplier.getVoterListDao();
        ((VoterListDao)dao).forPollEquals(poll).addNull("parent").tryFindUnique().ifPresent(((VoterListDao)dao)::delete);
        PollEventDao pollEventDao = this.daoSupplier.getPollEventDao();
        List<PollEvent> pollEvents = pollEventDao.findAllByPoll(poll);
        pollEventDao.deleteAll(pollEvents);
        PollFeedDao pollFeedDao = this.daoSupplier.getPollFeedDao();
        pollFeedDao.tryFindByPoll(poll).ifPresent(pollFeedDao::delete);
        this.deleteFromParent(poll);
    }

    public Collection<Poll> findPollsWithReminderNeeded() {
        Calendar calendar = Calendar.getInstance();
        Date now = calendar.getTime();
        return this.forHql("FROM " + Poll.class.getCanonicalName() + " p WHERE p.endDate IS NOT NULL AND p.pollEndReminderSent = false AND p.notifyMeHoursBeforePollEnds > 0").findAll().stream().filter(poll -> {
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(poll.getEndDate());
            calendar2.add(10, -1 * poll.getNotifyMeHoursBeforePollEnds());
            Date notifyDate = calendar2.getTime();
            return notifyDate.before(now) && now.before(poll.getEndDate());
        }).collect(Collectors.toList());
    }

    public boolean setFlagNotificationMaxVoterSend(Poll poll) {
        int nbModif = this.jpaSupport.execute("UPDATE " + Poll.class.getCanonicalName() + " SET notificationMaxVoterSend = true WHERE topiaId = :topiaId AND notificationMaxVoterSend = false", Collections.singletonMap("topiaId", poll.getTopiaId()));
        return nbModif > 0;
    }
}

