/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.persistence.topia.internal.support;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import jakarta.persistence.FlushModeType;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.Strings;
import org.chorem.pollen.persistence.topia.QueryMissingOrderException;
import org.chorem.pollen.persistence.topia.TopiaException;
import org.chorem.pollen.persistence.topia.TopiaNonUniqueResultException;
import org.chorem.pollen.persistence.topia.TopiaQueryException;
import org.chorem.pollen.persistence.topia.internal.support.SlowQueryWatcher;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.loader.MultipleBagFetchException;
import org.hibernate.query.Query;

public record HibernateJpaSupport(Supplier<Session> sessionSupplier, Optional<Duration> slowQueriesThreshold) {
    private <T> Query<T> prepareQuery(String jpaql, Map<String, Object> parameters) {
        this.checkHqlParameters(parameters);
        Query query = this.sessionSupplier.get().createQuery(jpaql);
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            Object unproxyfied = Hibernate.unproxy((Object)value);
            if (value.getClass().isArray()) {
                query.setParameterList(name, (Object[])unproxyfied);
                continue;
            }
            if (value instanceof Collection) {
                query.setParameterList(name, (Collection)unproxyfied);
                continue;
            }
            query.setParameter(name, unproxyfied);
        }
        query.setFlushMode(FlushModeType.AUTO);
        return query;
    }

    private void checkHqlParameters(Map<String, Object> parameters) {
        Preconditions.checkArgument((!parameters.containsKey("object") ? 1 : 0) != 0, (Object)"'object' is not a valid parameter name in HQL");
    }

    public <T> List<T> findAll(String jpaql, Map<String, Object> parameters) {
        Query<T> query = this.prepareQuery(jpaql, parameters);
        SlowQueryWatcher ignored = this.monitorQuery(query, parameters);
        try {
            List list = query.list();
            if (ignored != null) {
                ignored.close();
            }
            return list;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (MultipleBagFetchException mbfe) {
                throw new TopiaQueryException("unable to fetch multiple bags during findAll: " + String.valueOf(mbfe.getBagRoles()), mbfe, jpaql);
            }
            catch (RuntimeException re) {
                throw new TopiaQueryException("unable to findAll", re, jpaql);
            }
        }
    }

    public <T> T findAny(String jpaql, Map<String, Object> parameters) {
        List<T> results = this.find0(jpaql, 0, 0, parameters);
        return (T)Iterables.getOnlyElement(results, null);
    }

    public <T> T findUnique(String jpaql, Map<String, Object> parameters) {
        List<T> results = this.find0(jpaql, 0, 1, parameters);
        if (results.size() > 1) {
            String message = String.format("Query '%s' returns more than 1 unique result", jpaql);
            throw new TopiaNonUniqueResultException(message, parameters);
        }
        return (T)Iterables.getOnlyElement(results, null);
    }

    private boolean hqlContainsOrderBy(String hql) {
        return hql.toLowerCase().contains("order by");
    }

    public <T> List<T> find(String jpaql, int startIndex, int endIndex, Map<String, Object> parameters) throws QueryMissingOrderException {
        if (!this.hqlContainsOrderBy(jpaql)) {
            throw new QueryMissingOrderException(jpaql);
        }
        return this.find0(jpaql, startIndex, endIndex, parameters);
    }

    private <T> List<T> find0(String jpaql, int startIndex, int endIndex, Map<String, Object> parameters) {
        Query<T> query = this.prepareQuery(jpaql, parameters);
        query.setFirstResult(startIndex);
        if (endIndex >= 0 && endIndex != Integer.MAX_VALUE) {
            Preconditions.checkArgument((startIndex <= endIndex ? 1 : 0) != 0, (Object)("startIndex " + startIndex + " > endIndex" + endIndex));
            query.setMaxResults(endIndex - startIndex + 1);
        }
        SlowQueryWatcher ignored = this.monitorQuery(query, parameters);
        try {
            List list = query.list();
            if (ignored != null) {
                ignored.close();
            }
            return list;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (MultipleBagFetchException mbfe) {
                throw new TopiaQueryException("unable to fetch multiple bags during find page startIndex=" + startIndex + ", endIndex=" + endIndex + ": " + String.valueOf(mbfe.getBagRoles()), mbfe, jpaql);
            }
            catch (RuntimeException e) {
                throw new TopiaQueryException("unable to find page startIndex=" + startIndex + ", endIndex=" + endIndex, e, jpaql);
            }
        }
    }

    public int execute(String jpaql, Map<String, Object> parameters) {
        Query query = this.prepareQuery(jpaql, parameters);
        SlowQueryWatcher ignored = this.monitorQuery(query, parameters);
        try {
            int n = query.executeUpdate();
            if (ignored != null) {
                ignored.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (MultipleBagFetchException mbfe) {
                throw new TopiaQueryException("unable to fetch multiple bags during execute: " + String.valueOf(mbfe.getBagRoles()), mbfe, jpaql);
            }
            catch (RuntimeException e) {
                throw new TopiaQueryException("unable to execute query", e, jpaql);
            }
        }
    }

    public void save(Object object) {
        try {
            this.sessionSupplier.get().save(object);
        }
        catch (HibernateException eee) {
            throw new TopiaException("Unable to 'save' instance", eee);
        }
    }

    public void saveOrUpdate(Object object) {
        try {
            this.sessionSupplier.get().saveOrUpdate(object);
        }
        catch (HibernateException eee) {
            throw new TopiaException("Unable to 'saveOrUpdate' instance", eee);
        }
    }

    public void delete(Object object) {
        try {
            this.sessionSupplier.get().delete(object);
        }
        catch (HibernateException eee) {
            throw new TopiaException("Unable to 'delete' instance", eee);
        }
    }

    private SlowQueryWatcher monitorQuery(Query<?> query, Map<String, Object> args) {
        if (this.slowQueriesThreshold.isEmpty()) {
            return null;
        }
        Supplier<String> descriptionSupplier = () -> {
            String description = "HQL query: " + query.getQueryString();
            if (MapUtils.isNotEmpty((Map)args)) {
                Map<String, Object> notTooLongArgs = this.truncateLongArgs(args);
                description = description + " -- with args: " + String.valueOf(notTooLongArgs);
            }
            return description;
        };
        long thresholdMillis = this.slowQueriesThreshold.get().toMillis();
        return SlowQueryWatcher.start(descriptionSupplier, thresholdMillis);
    }

    private Map<String, Object> truncateLongArgs(Map<String, Object> args) {
        Preconditions.checkNotNull(args);
        return Maps.transformValues(args, value -> {
            Collection collection;
            int size;
            if (value instanceof Collection && (size = (collection = (Collection)value).size()) > 100) {
                Iterable limited = Iterables.limit((Iterable)collection, (int)100);
                String limitedString = limited.toString();
                return String.format("%s ... and %d more]", Strings.CS.removeEnd(limitedString, (CharSequence)"]"), size - 100);
            }
            return value;
        });
    }
}

