/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.persistence.entity;

import java.util.HashMap;
import org.chorem.pollen.persistence.AbstractPollenDao;
import org.chorem.pollen.persistence.entity.PollenUser;
import org.chorem.pollen.persistence.entity.UserCredential;

public class UserCredentialDao
extends AbstractPollenDao<UserCredential> {
    @Override
    public Class<UserCredential> getEntityClass() {
        return UserCredential.class;
    }

    @Override
    public void delete(UserCredential entity) {
        if (!entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + String.valueOf(entity) + " is not persisted, you can't delete it");
        }
        super.delete(entity);
    }

    public boolean isCredentialValid(String provider, String credentialUserId, String userTopiaId, String email) {
        String query = "SELECT COUNT(*) FROM " + PollenUser.class.getName() + " AS user LEFT JOIN user.userCredential AS credential";
        if (email != null) {
            query = query + " LEFT JOIN user.emailAddresses AS emailAddress";
        }
        query = query + " WHERE (credential.provider = :provider AND credential.userId = :credentialUserId)";
        if (email != null) {
            query = query + " OR user.topiaId != :userTopiaId AND (credential.email = :credentialEmail OR emailAddress.emailAddress = :emailAddress)";
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("provider", provider);
        params.put("credentialUserId", credentialUserId);
        if (email != null) {
            params.put("userTopiaId", userTopiaId);
            params.put("credentialEmail", email);
            params.put("emailAddress", email);
        }
        return this.count(query, params) == 0L;
    }
}

