/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.persistence.entity;

import java.util.Collection;
import java.util.List;
import org.chorem.pollen.persistence.AbstractPollenDao;
import org.chorem.pollen.persistence.AbstractPollenEntity;
import org.chorem.pollen.persistence.entity.Choice;
import org.chorem.pollen.persistence.entity.Comment;
import org.chorem.pollen.persistence.entity.FavoriteList;
import org.chorem.pollen.persistence.entity.Poll;
import org.chorem.pollen.persistence.entity.PollenPrincipal;
import org.chorem.pollen.persistence.entity.PollenToken;
import org.chorem.pollen.persistence.entity.PollenUser;
import org.chorem.pollen.persistence.entity.Vote;
import org.chorem.pollen.persistence.entity.VoterListMember;
import org.chorem.pollen.persistence.topia.query.AddCriteriaOrRunQueryStep;

public class PollenPrincipalDao
extends AbstractPollenDao<PollenPrincipal> {
    @Override
    public Class<PollenPrincipal> getEntityClass() {
        return PollenPrincipal.class;
    }

    @Override
    public void delete(PollenPrincipal entity) {
        if (!entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + String.valueOf(entity) + " is not persisted, you can't delete it");
        }
        List list = this.daoSupplier.getCommentDao().forAuthorEquals(entity).findAll();
        for (AbstractPollenEntity item : list) {
            if (!entity.equals(((Comment)item).getAuthor())) continue;
            ((Comment)item).setAuthor(null);
        }
        list = this.daoSupplier.getChoiceDao().forCreatorEquals(entity).findAll();
        for (AbstractPollenEntity item : list) {
            if (!entity.equals(((Choice)item).getCreator())) continue;
            ((Choice)item).setCreator(null);
        }
        list = this.daoSupplier.getPollDao().forCreatorEquals(entity).findAll();
        for (AbstractPollenEntity item : list) {
            if (!entity.equals(((Poll)item).getCreator())) continue;
            ((Poll)item).setCreator(null);
        }
        list = this.daoSupplier.getVoteDao().forVoterEquals(entity).findAll();
        for (AbstractPollenEntity item : list) {
            if (!entity.equals(((Vote)item).getVoter())) continue;
            ((Vote)item).setVoter(null);
        }
        list = this.daoSupplier.getFavoriteListDao().forOwnerEquals(entity).findAll();
        for (AbstractPollenEntity item : list) {
            if (!entity.equals(((FavoriteList)item).getOwner())) continue;
            ((FavoriteList)item).setOwner(null);
        }
        list = this.daoSupplier.getVoterListMemberDao().forMemberEquals(entity).findAll();
        for (AbstractPollenEntity item : list) {
            if (!entity.equals(((VoterListMember)item).getMember())) continue;
            ((VoterListMember)item).setMember(null);
        }
        super.delete(entity);
    }

    public AddCriteriaOrRunQueryStep<PollenPrincipal> forEmailIn(Collection<String> v) {
        return this.forIn("email", v);
    }

    public PollenPrincipal findByPermissionToken(String permissionToken) {
        return (PollenPrincipal)this.forEquals("permission.token", permissionToken).findUnique();
    }

    public AddCriteriaOrRunQueryStep<PollenPrincipal> forPermissionEquals(PollenToken v) {
        return this.forEquals("permission", v);
    }

    public AddCriteriaOrRunQueryStep<PollenPrincipal> forPollenUserEquals(PollenUser v) {
        return this.forEquals("pollenUser", v);
    }
}

