/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.persistence.entity;

import java.util.List;
import org.chorem.pollen.persistence.AbstractPollenDao;
import org.chorem.pollen.persistence.AbstractPollenEntity;
import org.chorem.pollen.persistence.entity.ChildFavoriteList;
import org.chorem.pollen.persistence.entity.ChildFavoriteListDao;
import org.chorem.pollen.persistence.entity.FavoriteList;
import org.chorem.pollen.persistence.entity.FavoriteListMember;
import org.chorem.pollen.persistence.entity.FavoriteListMemberDao;
import org.chorem.pollen.persistence.entity.PollenPrincipal;
import org.chorem.pollen.persistence.entity.PollenUser;
import org.chorem.pollen.persistence.topia.HqlAndParametersBuilder;
import org.chorem.pollen.persistence.topia.query.AddCriteriaOrRunQueryStep;
import org.nuiton.util.pagination.PaginationParameter;
import org.nuiton.util.pagination.PaginationResult;

public class FavoriteListDao
extends AbstractPollenDao<FavoriteList> {
    @Override
    public Class<FavoriteList> getEntityClass() {
        return FavoriteList.class;
    }

    public AddCriteriaOrRunQueryStep<FavoriteList> forOwnerEquals(PollenPrincipal v) {
        return this.forEquals("owner", v);
    }

    public void deleteFromParent(FavoriteList entity) {
        if (!entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + String.valueOf(entity) + " is not persisted, you can't delete it");
        }
        List list = this.daoSupplier.getFavoriteListMemberDao().forFavoriteListEquals(entity).findAll();
        for (AbstractPollenEntity item : list) {
            if (!entity.equals(((FavoriteListMember)item).getFavoriteList())) continue;
            ((FavoriteListMember)item).setFavoriteList(null);
        }
        list = this.daoSupplier.getFavoriteListDao().forProperties("parentLists", entity, new Object[0]).findAll();
        for (AbstractPollenEntity item : list) {
            if (!entity.equals(((FavoriteList)item).getParentLists())) continue;
            ((FavoriteList)item).setParentLists(null);
        }
        list = this.daoSupplier.getChildFavoriteListDao().forChildEquals(entity).findAll();
        for (AbstractPollenEntity item : list) {
            if (!entity.equals(((ChildFavoriteList)item).getChild())) continue;
            ((ChildFavoriteList)item).setChild(null);
        }
        list = this.daoSupplier.getChildFavoriteListDao().forParentEquals(entity).findAll();
        for (AbstractPollenEntity item : list) {
            if (!entity.equals(((ChildFavoriteList)item).getParent())) continue;
            ((ChildFavoriteList)item).setParent(null);
        }
        super.delete(entity);
    }

    public AddCriteriaOrRunQueryStep<FavoriteList> forPollenUserEquals(PollenUser v) {
        return this.forEquals("pollenUser", v);
    }

    public PaginationResult<FavoriteList> search(PollenUser user, String search, PaginationParameter page) {
        HqlAndParametersBuilder builder = this.newHqlAndParametersBuilder();
        builder.addEquals("pollenUser", user);
        builder.addWhereClause(this.getSearchClause(builder.getAlias(), builder.getHqlParameters(), "name", search));
        return this.findPage(builder.getHql(), builder.getHqlParameters(), page);
    }

    @Override
    public void delete(FavoriteList entity) {
        FavoriteListMemberDao memberDao = this.daoSupplier.getFavoriteListMemberDao();
        List members = memberDao.forFavoriteListEquals(entity).findAll();
        memberDao.deleteAll(members);
        ChildFavoriteListDao childDao = this.daoSupplier.getChildFavoriteListDao();
        List children = childDao.forChildEquals(entity).findAll();
        childDao.deleteAll(children);
        List parents = childDao.forParentEquals(entity).findAll();
        childDao.deleteAll(parents);
        this.deleteFromParent(entity);
    }
}

