/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.persistence.entity;

import java.util.List;
import org.chorem.pollen.persistence.AbstractPollenDao;
import org.chorem.pollen.persistence.entity.Choice;
import org.chorem.pollen.persistence.entity.ChoiceType;
import org.chorem.pollen.persistence.entity.PollenPrincipal;
import org.chorem.pollen.persistence.entity.PollenResource;
import org.chorem.pollen.persistence.entity.PollenResourceDao;
import org.chorem.pollen.persistence.entity.Question;
import org.chorem.pollen.persistence.entity.VoteToChoice;
import org.chorem.pollen.persistence.entity.VoteToChoiceDao;
import org.chorem.pollen.persistence.topia.query.AddCriteriaOrRunQueryStep;

public class ChoiceDao
extends AbstractPollenDao<Choice> {
    @Override
    public Class<Choice> getEntityClass() {
        return Choice.class;
    }

    public void deleteFromParent(Choice entity) {
        if (!entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + String.valueOf(entity) + " is not persisted, you can't delete it");
        }
        List list = this.daoSupplier.getVoteToChoiceDao().forChoiceEquals(entity).findAll();
        for (VoteToChoice item : list) {
            if (!entity.equals(item.getChoice())) continue;
            item.setChoice(null);
        }
        super.delete(entity);
    }

    public AddCriteriaOrRunQueryStep<Choice> forQuestionEquals(Question v) {
        return this.forEquals("question", v);
    }

    public List<Choice> findAllByQuestionOrdered(Question question) {
        return this.forQuestionEquals(question).setOrderByArguments("choiceOrder").findAll();
    }

    @Override
    public void delete(Choice entity) {
        if (entity.getChoiceType() == ChoiceType.RESOURCE) {
            PollenResourceDao dao = this.daoSupplier.getPollenResourceDao();
            PollenResource resource = (PollenResource)dao.forTopiaIdEquals(entity.getChoiceValue()).findUnique();
            dao.delete(resource, entity.getTopiaId());
        }
        VoteToChoiceDao voteToChoiceDao = this.daoSupplier.getVoteToChoiceDao();
        List votesToChoice = voteToChoiceDao.forChoiceEquals(entity).findAll();
        voteToChoiceDao.deleteAll(votesToChoice);
        this.deleteFromParent(entity);
    }

    public AddCriteriaOrRunQueryStep<Choice> forCreatorEquals(PollenPrincipal v) {
        return this.forEquals("creator", v);
    }

    public AddCriteriaOrRunQueryStep<Choice> forChoiceValueAndChoiceTypeEquals(String v, ChoiceType choiceType) {
        return this.forEquals("choiceValue", v).addEquals("choiceType", (Object)choiceType);
    }

    public AddCriteriaOrRunQueryStep<Choice> forChoiceValueAndChoiceTypeEqualsAndTopiaIdNotEquals(String v, ChoiceType choiceType, String choiceId) {
        return this.forChoiceValueAndChoiceTypeEquals(v, choiceType).addNotEquals("topiaId", choiceId);
    }
}

