/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.persistence;

import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.chorem.pollen.persistence.PollenPersistenceConfiguration;
import org.chorem.pollen.persistence.topia.TopiaMisconfigurationException;

public class PollenPersistenceConfigurationBuilder {
    protected static final String CONFIG_DEFAULT_SCHEMA = "hibernate.default_schema";
    protected static final String CONFIG_USER = "jakarta.persistence.jdbc.user";
    protected static final String CONFIG_PASS = "jakarta.persistence.jdbc.password";
    protected static final String CONFIG_DRIVER = "jakarta.persistence.jdbc.driver";
    protected static final String CONFIG_URL = "jakarta.persistence.jdbc.url";
    protected static final String CONFIG_PERSISTENCE_INIT_SCHEMA = "topia.persistence.initSchema";
    protected static final String CONFIG_PERSISTENCE_VALIDATE_SCHEMA = "topia.persistence.validateSchema";
    protected static final String CONFIG_PERSISTENCE_USE_HIKARI_FOR_JDBC_CONNECTION_POOLING = "topia.persistence.useHikariForJdbcConnectionPooling";
    protected static final String CONFIG_PERSISTENCE_MONITORING_SLOW_QUERY_THRESHOLD = "topia.persistence.monitoring.slowQueryThreshold";
    protected static final String TOPIA_SERVICE_MIGRATION_PREFIX = "topia.service.migration.";
    protected static final Set<String> MAIN_CONFIGURATION = Set.of("jakarta.persistence.jdbc.driver", "jakarta.persistence.jdbc.url", "jakarta.persistence.jdbc.user", "jakarta.persistence.jdbc.password");

    public void check(PollenPersistenceConfiguration topiaConfiguration) throws TopiaMisconfigurationException {
        if (StringUtils.isBlank((CharSequence)topiaConfiguration.getJdbcConnectionUrl())) {
            throw new TopiaMisconfigurationException("you must provide JDBC connection URL", topiaConfiguration);
        }
        if (StringUtils.isBlank((CharSequence)topiaConfiguration.getJdbcConnectionUser())) {
            throw new TopiaMisconfigurationException("you must provide JDBC connection user", topiaConfiguration);
        }
        if (topiaConfiguration.getJdbcConnectionPassword() == null) {
            throw new TopiaMisconfigurationException("you must provide JDBC connection password", topiaConfiguration);
        }
        if (topiaConfiguration.getJdbcDriverClass() == null) {
            throw new TopiaMisconfigurationException("you must provide JDBC connection driver", topiaConfiguration);
        }
        Map<String, String> hibernateExtraConfiguration = topiaConfiguration.getHibernateExtraConfiguration();
        if (hibernateExtraConfiguration.containsKey("hibernate.hbm2ddl.auto")) {
            throw new TopiaMisconfigurationException("you must not use hibernate.hbm2ddl.auto configuration directive", topiaConfiguration);
        }
        for (Map.Entry<String, String> entry : hibernateExtraConfiguration.entrySet()) {
            String key = entry.getKey();
            boolean keyIsOnTopic = key.startsWith("hibernate.") || key.startsWith("javax.persistence.") || key.startsWith("jakarta.persistence.");
            boolean entryIsOk = keyIsOnTopic && !MAIN_CONFIGURATION.contains(key);
            if (entryIsOk) continue;
            throw new TopiaMisconfigurationException("hibernate extra configuration is " + String.valueOf(hibernateExtraConfiguration) + " but it should not contains a key " + key, topiaConfiguration);
        }
        Optional<Duration> slowQueriesThreshold = topiaConfiguration.getSlowQueriesThreshold();
        if (slowQueriesThreshold.isPresent() && slowQueriesThreshold.get().isNegative()) {
            throw new TopiaMisconfigurationException("slow queries threshold can't be negative", topiaConfiguration);
        }
    }

    public PollenPersistenceConfiguration readMap(Map<String, String> configuration) {
        String url = configuration.get(CONFIG_URL);
        String user = configuration.get(CONFIG_USER);
        String password = configuration.get(CONFIG_PASS);
        String driverName = configuration.get(CONFIG_DRIVER);
        PollenPersistenceConfiguration result = new PollenPersistenceConfiguration(url, user, password, driverName);
        String initSchemaConfigValue = configuration.get(CONFIG_PERSISTENCE_INIT_SCHEMA);
        boolean initSchema = StringUtils.isBlank((CharSequence)initSchemaConfigValue) || Boolean.parseBoolean(initSchemaConfigValue);
        result.setInitSchema(initSchema);
        String validateSchemaConfigValue = configuration.get(CONFIG_PERSISTENCE_VALIDATE_SCHEMA);
        boolean validateSchema = StringUtils.isBlank((CharSequence)validateSchemaConfigValue) || Boolean.parseBoolean(validateSchemaConfigValue);
        result.setValidateSchema(validateSchema);
        String useHikariForJdbcConnectionPoolingConfigValue = configuration.get(CONFIG_PERSISTENCE_USE_HIKARI_FOR_JDBC_CONNECTION_POOLING);
        boolean useHikariForJdbcConnectionPooling = StringUtils.isBlank((CharSequence)useHikariForJdbcConnectionPoolingConfigValue) || Boolean.parseBoolean(useHikariForJdbcConnectionPoolingConfigValue);
        result.setUseHikariForJdbcConnectionPooling(useHikariForJdbcConnectionPooling);
        String slowQueryThresholdString = configuration.get(CONFIG_PERSISTENCE_MONITORING_SLOW_QUERY_THRESHOLD);
        Duration slowQueryThreshold = StringUtils.isBlank((CharSequence)slowQueryThresholdString) ? null : Duration.parse(slowQueryThresholdString);
        result.setSlowQueriesThreshold(slowQueryThreshold);
        result.setSchemaName(configuration.get(CONFIG_DEFAULT_SCHEMA));
        for (Map.Entry<String, String> entry : configuration.entrySet()) {
            String key = entry.getKey();
            boolean keyMustBeIncludedInHibernateExtraConfiguration = !MAIN_CONFIGURATION.contains(key) && (key.startsWith("hibernate.") || key.startsWith("javax.persistence."));
            if (!keyMustBeIncludedInHibernateExtraConfiguration) continue;
            result.getHibernateExtraConfiguration().put(key, entry.getValue());
        }
        Map<String, String> migrationServiceConfiguration = result.getMigrationServiceConfiguration();
        for (Map.Entry<String, String> entry : configuration.entrySet()) {
            String configurationKey = entry.getKey();
            if (!configurationKey.startsWith(TOPIA_SERVICE_MIGRATION_PREFIX)) continue;
            String configurationValue = entry.getValue();
            String serviceConfigurationKey = Strings.CS.removeStart(configurationKey, (CharSequence)TOPIA_SERVICE_MIGRATION_PREFIX);
            migrationServiceConfiguration.put(serviceConfigurationKey, configurationValue);
        }
        this.check(result);
        return result;
    }

    public Map<String, String> toMap(PollenPersistenceConfiguration topiaConfiguration) {
        this.check(topiaConfiguration);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(CONFIG_URL, topiaConfiguration.getJdbcConnectionUrl());
        map.put(CONFIG_USER, topiaConfiguration.getJdbcConnectionUser());
        map.put(CONFIG_PASS, topiaConfiguration.getJdbcConnectionPassword());
        map.put(CONFIG_DRIVER, topiaConfiguration.getJdbcDriverClass().getName());
        if (!topiaConfiguration.isInitSchema()) {
            map.put(CONFIG_PERSISTENCE_INIT_SCHEMA, String.valueOf(topiaConfiguration.isInitSchema()));
        }
        if (!topiaConfiguration.isValidateSchema()) {
            map.put(CONFIG_PERSISTENCE_VALIDATE_SCHEMA, String.valueOf(topiaConfiguration.isValidateSchema()));
        }
        if (!topiaConfiguration.isUseHikariForJdbcConnectionPooling()) {
            map.put(CONFIG_PERSISTENCE_USE_HIKARI_FOR_JDBC_CONNECTION_POOLING, String.valueOf(topiaConfiguration.isUseHikariForJdbcConnectionPooling()));
        }
        topiaConfiguration.getSlowQueriesThreshold().map(Duration::toString).ifPresent(threshold -> map.put(CONFIG_PERSISTENCE_MONITORING_SLOW_QUERY_THRESHOLD, (String)threshold));
        if (topiaConfiguration.getSchemaName() != null) {
            map.put(CONFIG_DEFAULT_SCHEMA, topiaConfiguration.getSchemaName());
        }
        map.putAll(topiaConfiguration.getHibernateExtraConfiguration());
        return map;
    }
}

